/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.runtime.alias;

import pl.decerto.hyperon.runtime.model.Parameter;
import pl.decerto.hyperon.runtime.model.ParameterLevel;

public class LevelMapper {
    private final int[] mapping;
    private final int slaveLevelCnt;
    private final int masterLevelCnt;
    private final boolean identical;

    public LevelMapper(Parameter master, Parameter slave) {
        this.slaveLevelCnt = slave.getLevelCount();
        this.masterLevelCnt = master.getLevelCount();
        this.mapping = new int[this.slaveLevelCnt];
        block0: for (int i = 0; i < this.slaveLevelCnt; ++i) {
            ParameterLevel slaveLevel = slave.getLevel(i);
            for (int j = 0; j < this.masterLevelCnt; ++j) {
                ParameterLevel masterLevel = master.getLevel(j);
                if (!masterLevel.getName().equals(slaveLevel.getName())) continue;
                this.mapping[i] = j;
                continue block0;
            }
        }
        this.identical = this.checkIdentical();
    }

    public final int size() {
        return this.mapping.length;
    }

    public final int mapIndex(int i) {
        return this.mapping[i];
    }

    public final boolean isNotIdentical() {
        return !this.identical;
    }

    private boolean checkIdentical() {
        if (this.getMasterLevelCnt() != this.getSlaveLevelCnt()) {
            return false;
        }
        for (int i = 0; i < this.mapping.length; ++i) {
            if (this.mapping[i] == i) continue;
            return false;
        }
        return true;
    }

    public int[] getMapping() {
        return this.mapping;
    }

    public int getSlaveLevelCnt() {
        return this.slaveLevelCnt;
    }

    public int getMasterLevelCnt() {
        return this.masterLevelCnt;
    }

    public boolean isIdentical() {
        return this.identical;
    }
}

