/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.runtime.core;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.smartparam.engine.core.ParamEngine;
import org.smartparam.engine.core.ParamEngineRuntimeConfig;
import org.smartparam.engine.core.context.ParamContext;
import org.smartparam.engine.core.output.ParamValue;
import pl.decerto.hyperon.runtime.core.DigestElementCodeProcessor;
import pl.decerto.hyperon.runtime.core.EmptyParamValue;
import pl.decerto.hyperon.runtime.core.HyperonEngine;
import pl.decerto.hyperon.runtime.core.domain.DomainCache;
import pl.decerto.hyperon.runtime.core.versioninterceptor.EffectiveVersionConfiguration;
import pl.decerto.hyperon.runtime.core.versioninterceptor.VersionInterceptor;
import pl.decerto.hyperon.runtime.distinct.DistinctFilter;
import pl.decerto.hyperon.runtime.exception.HyperonIllegalStateException;
import pl.decerto.hyperon.runtime.model.HyperonDomainObject;
import pl.decerto.hyperon.runtime.model.Parameter;
import pl.decerto.hyperon.runtime.model.Type;
import pl.decerto.hyperon.runtime.model.proxy.HyperonDomainObjectProxy;
import pl.decerto.hyperon.runtime.model.region.RegionVersionIdentifier;
import pl.decerto.hyperon.runtime.profiler.engine.EngineProfiler;
import pl.decerto.hyperon.runtime.rhino.value.RhinoParamValue;
import pl.decerto.hyperon.runtime.sorter.ParamSorter;

public class HyperonEngineImpl
implements HyperonEngine {
    private static final ParamValue EMPTY_PARAM_VALUE = new EmptyParamValue();
    private static final EngineProfiler profiler = EngineProfiler.PARAMETER;
    private final ParamEngine engine;
    private final ParamSorter paramSorter = new ParamSorter();
    private final DistinctFilter distinct = new DistinctFilter();
    private final boolean valueNeverNull;
    private final VersionInterceptor versionInterceptor;
    private final DomainCache domainCache;
    private final DigestElementCodeProcessor digestElementCodeProcessor;

    public HyperonEngineImpl(ParamEngine engine, DomainCache domainCache, VersionInterceptor versionInterceptor, boolean valueNeverNull) {
        this.engine = engine;
        this.domainCache = domainCache;
        this.versionInterceptor = versionInterceptor;
        this.valueNeverNull = valueNeverNull;
        this.digestElementCodeProcessor = new DigestElementCodeProcessor(versionInterceptor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ParamValue get(String parameterName, ParamContext ctx) {
        long t = System.currentTimeMillis();
        String uid = this.versionInterceptor.decorateParameterUid(parameterName);
        try {
            ParamValue paramValue = this.get0(uid, ctx);
            return paramValue;
        }
        finally {
            profiler.addGetMeasure(uid, t, System.currentTimeMillis());
        }
    }

    @Deprecated
    public ParamValue get0(String uid, ParamContext ctx) {
        this.reset(ctx);
        ParamValue value = this.engine.get(uid, ctx);
        if (value == null) {
            return this.getNull();
        }
        Parameter def = (Parameter)value.getMetadata();
        if (def == null) {
            throw new HyperonIllegalStateException("Parameter metadata not found in cache: " + uid);
        }
        if (def.isDistinct()) {
            value = this.distinct.filter(value);
        }
        if (def.getSort() != null) {
            value = this.paramSorter.sort(value, def.getSort());
        }
        return value;
    }

    @Override
    public Object call(String functionName, ParamContext ctx, Object ... args) {
        this.reset(ctx);
        String uid = this.versionInterceptor.decorateFunctionUid(functionName);
        Object result = this.engine.callFunction(uid, this.merge(ctx, args));
        if (result instanceof RhinoParamValue) {
            result = ((RhinoParamValue)result).unwrap();
        }
        return result;
    }

    @Override
    public ParamEngineRuntimeConfig runtimeConfiguration() {
        return this.engine.runtimeConfiguration();
    }

    @Override
    public void setEffectiveVersion(String region, String version) {
        this.versionInterceptor.setEffectiveVersion(region, version);
    }

    @Override
    public void setEffectiveVersion(String profileCode, String regionCode, String version) {
        this.versionInterceptor.setEffectiveVersion(profileCode, regionCode, version);
    }

    @Override
    public void setEffectiveDate(Date date) {
        this.versionInterceptor.setEffectiveDate(date);
    }

    @Override
    public void clearEffectiveVersion(String region) {
        this.versionInterceptor.clearEffectiveVersion(region);
    }

    @Override
    public void clearEffectiveVersion(String profileCode, String regionCode) {
        this.versionInterceptor.clearEffectiveVersion(profileCode, regionCode);
    }

    @Override
    public void clearEffectiveVersions() {
        this.versionInterceptor.clearEffectiveVersions();
    }

    @Override
    public void clearEffectiveDate() {
        this.versionInterceptor.clearEffectiveDate();
    }

    @Override
    public void clearEffectiveSetup() {
        this.versionInterceptor.clearEffectiveSetup();
    }

    @Override
    public List<String> getProfiles() {
        return new ArrayList<String>(this.domainCache.getProfiles());
    }

    @Override
    public Set<String> getExistingProfiles() {
        return this.domainCache.getProfiles();
    }

    @Override
    public HyperonDomainObject getDomain(String profile, String objectPath) {
        HyperonDomainObject obj = this.getDomainObject(profile, objectPath);
        return obj != null ? new HyperonDomainObjectProxy(obj, this, profile, objectPath) : null;
    }

    @Override
    public String getDigest(Type type, String elementCode) {
        String preprocessedCode = this.digestElementCodeProcessor.preprocess(type, elementCode);
        return this.engine.getDigest(type, preprocessedCode);
    }

    private HyperonDomainObject getDomainObject(String profile, String objectPath) {
        Optional<EffectiveVersionConfiguration> effectiveVersionConfiguration = this.createEffectiveVersionConfiguration(profile);
        if (effectiveVersionConfiguration.isPresent()) {
            return this.domainCache.getDomain(profile, objectPath, effectiveVersionConfiguration.get());
        }
        return this.domainCache.getDomain(profile, objectPath);
    }

    private Optional<EffectiveVersionConfiguration> createEffectiveVersionConfiguration(String profile) {
        Set<RegionVersionIdentifier> effectiveVersions = this.versionInterceptor.getEffectiveVersions(profile);
        Date effectiveDate = this.versionInterceptor.getEffectiveDate().orElse(null);
        if (Objects.nonNull(effectiveDate)) {
            return Optional.of(EffectiveVersionConfiguration.withEffectiveVersionsAndDate(effectiveVersions, effectiveDate));
        }
        if (effectiveVersions.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(EffectiveVersionConfiguration.withEffectiveVersions(effectiveVersions));
    }

    private ParamValue getNull() {
        return this.valueNeverNull ? EMPTY_PARAM_VALUE : null;
    }

    private void reset(ParamContext ctx) {
        ctx.setLevelValues(null);
    }

    Object[] merge(ParamContext ctx, Object ... args) {
        if (args == null || args.length == 0) {
            return new Object[]{ctx};
        }
        Object[] result = new Object[args.length + 1];
        result[0] = ctx;
        System.arraycopy(args, 0, result, 1, args.length);
        return result;
    }

    @Deprecated
    public boolean isValueNeverNull() {
        return this.valueNeverNull;
    }

    @Deprecated
    public DomainCache getDomainCache() {
        return this.domainCache;
    }
}

