/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.runtime.core;

import io.higson.runtime.model.Type;
import java.util.Arrays;
import org.smartparam.engine.core.context.ParamContext;
import org.smartparam.engine.ext.FunctionInvokerInterceptor;
import pl.decerto.hyperon.runtime.core.HyperonEngine;
import pl.decerto.hyperon.runtime.decoder.CascadeDecoder;
import pl.decerto.hyperon.runtime.helper.TypeConverter;

public class StdFunctionInterceptor
implements FunctionInvokerInterceptor {
    private final TypeConverter type = TypeConverter.getInstance();
    private final HyperonEngine engine;
    private final CascadeDecoder decoder;

    public StdFunctionInterceptor(HyperonEngine engine) {
        this.decoder = new CascadeDecoder(engine);
        this.engine = engine;
    }

    @Override
    public Object invokeFunction(String name, ParamContext ctx, Object ... args) {
        String text = name.trim();
        if (Type.isFunction(text)) {
            return this.decoder.cascadeCall(text.substring(3), ctx);
        }
        if (Type.isParameter(text)) {
            return this.cascadeToParameter(ctx, text);
        }
        return this.engine.call(name, ctx, args);
    }

    private Object cascadeToParameter(ParamContext ctx, String text) {
        String[] cascadeResults = (String[])Arrays.stream(this.decoder.cascadeGet(text.substring(3), ctx)).map(this.type::getString).toArray(String[]::new);
        return cascadeResults.length == 1 ? cascadeResults[0] : cascadeResults;
    }
}

