/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.runtime.decoder;

import org.smartparam.engine.util.EngineUtil;
import pl.decerto.hyperon.runtime.decoder.CascadeArg;
import pl.decerto.hyperon.runtime.decoder.CascadeArgType;
import pl.decerto.hyperon.runtime.decoder.FunctionCascadeRequest;
import pl.decerto.hyperon.runtime.decoder.InvalidFunctionCascadeRef;
import pl.decerto.hyperon.runtime.exception.HyperonRuntimeException;

public class FunctionCascadeParser {
    public FunctionCascadeRequest parse(String text) {
        int openingBracket;
        int openingBrace = this.indexOfAny(text = text.trim(), '(', '[');
        if (openingBrace < 0) {
            return new FunctionCascadeRequest(text);
        }
        if (openingBrace == 0) {
            throw new InvalidFunctionCascadeRef(text);
        }
        String name = text.substring(0, openingBrace).trim();
        FunctionCascadeRequest request = new FunctionCascadeRequest(name);
        int openingParenthesis = text.indexOf(40, openingBrace);
        if (openingParenthesis >= openingBrace) {
            request.setArgs(this.parseArguments(text, openingParenthesis));
        }
        if ((openingBracket = text.indexOf(91, openingBrace)) >= openingBrace) {
            request.setOutput(this.parseOutputDescriptor(text, openingBracket));
        }
        return request;
    }

    private String parseOutputDescriptor(String text, int openingBracket) {
        int closingBracket = text.indexOf(93, openingBracket + 1);
        if (closingBracket > openingBracket) {
            return text.substring(openingBracket + 1, closingBracket).trim();
        }
        throw new HyperonRuntimeException("Cascade function reference - bad syntax: " + text);
    }

    private CascadeArg[] parseArguments(String text, int openingParenthesis) {
        char separator;
        int closingParenthesis = text.indexOf(41, openingParenthesis + 1);
        if (closingParenthesis < 0) {
            throw new HyperonRuntimeException("Cascade function reference - bad syntax: " + text);
        }
        String argsText = text.substring(openingParenthesis + 1, closingParenthesis);
        String[] tokens = EngineUtil.split(argsText, separator = this.chooseSeparator(argsText));
        if (tokens.length == 0) {
            return null;
        }
        CascadeArg[] args = new CascadeArg[tokens.length];
        for (int i = 0; i < tokens.length; ++i) {
            args[i] = this.parseArg(tokens[i].trim());
        }
        return args;
    }

    private char chooseSeparator(String argsText) {
        return argsText.indexOf(59) >= 0 ? (char)';' : ',';
    }

    private CascadeArg parseArg(String token) {
        if (token.length() > 4 && token.startsWith("ctx:")) {
            return new CascadeArg(CascadeArgType.CONTEXT, token.substring(4));
        }
        if (token.length() > 4 && token.startsWith("ref:")) {
            return new CascadeArg(CascadeArgType.REF, token.substring(4));
        }
        return new CascadeArg(CascadeArgType.LITERAL, token);
    }

    private int indexOfAny(String str, char c1, char c2) {
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            char c = str.charAt(i);
            if (c != c1 && c != c2) continue;
            return i;
        }
        return -1;
    }
}

