/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.runtime.function.log;

import java.util.Collection;
import java.util.Collections;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.decerto.hyperon.runtime.core.HyperonEngine;
import pl.decerto.hyperon.runtime.function.log.FunctionLogLevelCache;
import pl.decerto.hyperon.runtime.function.log.FunctionLogLevelResolver;
import pl.decerto.hyperon.runtime.function.log.FunctionLogger;
import pl.decerto.hyperon.runtime.function.log.HyperonLogger;
import pl.decerto.hyperon.runtime.function.log.ListenableLogger;
import pl.decerto.hyperon.runtime.function.log.LogListener;
import pl.decerto.hyperon.runtime.model.Function;

public final class FunctionLoggerCreator {
    private static final Logger log = LoggerFactory.getLogger(FunctionLoggerCreator.class);
    private static final String LOGGER_NAME_PATTERN = "function.%s";
    private final Collection<LogListener> logListeners;
    private final FunctionLogLevelCache logLevelCache;
    private FunctionLogLevelResolver functionLogLevelResolver;

    public FunctionLoggerCreator(Collection<LogListener> logListeners, FunctionLogLevelCache logLevelCache) {
        this.logListeners = logListeners;
        this.logLevelCache = logLevelCache;
    }

    public FunctionLoggerCreator(Collection<LogListener> logListeners) {
        this(logListeners, new FunctionLogLevelCache());
    }

    public FunctionLoggerCreator() {
        this(Collections.emptyList());
    }

    public HyperonLogger createLogger(Function function) {
        String loggerName = String.format(LOGGER_NAME_PATTERN, function.getName());
        Logger logger = LoggerFactory.getLogger((String)loggerName);
        if (CollectionUtils.isNotEmpty(this.logListeners)) {
            return new ListenableLogger(new FunctionLogger(logger, function, this.functionLogLevelResolver), this.logListeners);
        }
        return new FunctionLogger(logger, function, this.functionLogLevelResolver);
    }

    public void setHyperonEngine(HyperonEngine hyperonEngine) {
        this.functionLogLevelResolver = new FunctionLogLevelResolver(hyperonEngine, this.logLevelCache);
        log.info("using function log level resolver: {}", (Object)this.functionLogLevelResolver);
    }
}

