/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.runtime.sql.dialect;

import jakarta.validation.constraints.NotNull;
import java.util.List;
import pl.decerto.hyperon.runtime.sql.dialect.DatabaseDialect;
import pl.decerto.hyperon.runtime.sql.dialect.exception.BadJdbcUrlStructureException;
import pl.decerto.hyperon.runtime.sql.dialect.exception.NotEqualDialectsException;
import pl.decerto.hyperon.runtime.sql.dialect.exception.NotProvidedStringValueException;
import pl.decerto.hyperon.runtime.sql.dialect.exception.NotRecognizedDialectException;

public final class DialectParser {
    private static final int JDBC_URL_INDEX = 0;
    private static final int DIALECT_URL_INDEX = 1;
    private static final String REGEX_COMMA = ":";
    private static final String SQL_SERVER_DIALECT = "sqlserver";

    private DialectParser() {
        throw new UnsupportedOperationException();
    }

    public static String getDatabaseDialect(@NotNull List<Object> objectList) {
        Object jdbcUrlProperty = objectList.get(0);
        Object databaseDialectProperty = objectList.get(1);
        if (jdbcUrlProperty instanceof String) {
            String propertiesDialect = null;
            if (databaseDialectProperty instanceof String) {
                propertiesDialect = (String)databaseDialectProperty;
            }
            return DialectParser.getDatabaseDialect((String)jdbcUrlProperty, propertiesDialect);
        }
        throw new NotProvidedStringValueException("JDBC Url is not a String object");
    }

    public static String getDatabaseDialect(@NotNull String jdbcUrl) {
        return DialectParser.getDatabaseDialect(jdbcUrl, null);
    }

    public static String getDatabaseDialect(@NotNull String jdbcUrl, String dialect) {
        String parsedDialect = DialectParser.getDialectFromJdbcUrl(jdbcUrl);
        if (dialect != null && !parsedDialect.equals(dialect)) {
            throw new NotEqualDialectsException(String.format("JDBC url dialect: %s is not equal with given properties database dialect: %s", parsedDialect, dialect));
        }
        return DialectParser.getDialectIfSupportedByHyperon(parsedDialect);
    }

    private static String getDialectIfSupportedByHyperon(String parsedDialect) {
        if (DatabaseDialect.supports(parsedDialect)) {
            return parsedDialect;
        }
        throw new NotRecognizedDialectException(String.format("JDBC Url contains database dialect which is not recognized or not supported. Supported dialects: %s", DatabaseDialect.getDialects()));
    }

    private static String getDialectFromJdbcUrl(String jdbcUrl) {
        String[] jdbcUrlProperties = jdbcUrl.split(REGEX_COMMA);
        if ("jdbc".equals(jdbcUrlProperties[0]) && jdbcUrlProperties[1] != null) {
            return DialectParser.getDialect(jdbcUrlProperties[1]);
        }
        throw new BadJdbcUrlStructureException("JDBC Url does not contain proper structure");
    }

    private static String getDialect(String parsedDialect) {
        if (SQL_SERVER_DIALECT.equals(parsedDialect)) {
            return DatabaseDialect.MSSQL2012.getDialect();
        }
        return parsedDialect;
    }
}

