/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.common.configuration;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;
import org.springframework.core.io.support.ResourcePropertySource;

public abstract class PropertiesInitializer
implements ApplicationContextInitializer<ConfigurableApplicationContext> {
    private static final Logger log = LoggerFactory.getLogger(PropertiesInitializer.class);
    public static final String CLASSPATH_PROPERTIES_NAME = "Config resource 'class path resource [application.yml]' via location 'optional:classpath:/'";

    public void initialize(ConfigurableApplicationContext ctx) {
        ConfigurableEnvironment environment = ctx.getEnvironment();
        MutablePropertySources propertySources = environment.getPropertySources();
        for (PropertiesDefinition definition : this.getPropertiesDefinitions()) {
            this.doInitialize(environment.resolvePlaceholders(definition.getUri()), definition.getName(), propertySources);
        }
    }

    protected abstract List<PropertiesDefinition> getPropertiesDefinitions();

    private void doInitialize(String uri, String name, MutablePropertySources propertySources) {
        ResourcePropertySource propertySource = this.loadProperties(uri, name);
        if (propertySource != null) {
            propertySources.addBefore(CLASSPATH_PROPERTIES_NAME, (PropertySource)propertySource);
            log.info("Properties {} loaded.", (Object)uri);
        }
    }

    private ResourcePropertySource loadProperties(String uri, String name) {
        try {
            return new ResourcePropertySource(name, uri);
        }
        catch (FileNotFoundException e) {
            log.debug("Properties {} not found. Skipping...", (Object)uri);
        }
        catch (IOException e) {
            log.warn("An error occurred while loading properties {}.", (Object)uri, (Object)e);
        }
        return null;
    }

    protected static class PropertiesDefinition {
        private final String uri;
        private final String name;

        public String getUri() {
            return this.uri;
        }

        public String getName() {
            return this.name;
        }

        public PropertiesDefinition(String uri, String name) {
            this.uri = uri;
            this.name = name;
        }
    }
}

