/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.common.logger;

import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import pl.decerto.hyperon.common.logger.ConfigurationLoggerSection;
import pl.decerto.hyperon.common.logger.LogoProvider;

class ConfigurationPrinter {
    private static final int FRAME_WIDTH = 185;
    private static final int CONTENT_WIDTH = 181;
    private static final int COLUMN_WIDTH = 89;
    private static final String SEPARATOR = "-";
    private static final String FRAME_LEFT = "- ";
    private static final String FRAME_RIGHT = " -";
    private static final String CONFIGURATION_SEPARATOR = "-".repeat(185);
    private static final int WORD_SPACING = 2;
    private final LogoProvider logoProvider;

    String print(List<ConfigurationLoggerSection> sections) {
        StringBuilder content = new StringBuilder("\n");
        this.printLogo(content);
        this.printConfigurationSeparator(content);
        this.printSections(content, sections);
        this.printConfigurationSeparator(content);
        return content.toString();
    }

    private void printConfigurationSeparator(StringBuilder content) {
        content.append(CONFIGURATION_SEPARATOR).append("\n");
    }

    private void printLogo(StringBuilder content) {
        this.logoProvider.getLogo().ifPresent(logo -> content.append((String)logo).append("\n"));
    }

    private void printSections(StringBuilder content, List<ConfigurationLoggerSection> sections) {
        List<ConfigurationLoggerSection> mergedSections = this.mergeDuplicatedSections(sections);
        List<ConfigurationLoggerSection> sortedMergedSections = this.sortSections(mergedSections);
        for (ConfigurationLoggerSection section : sortedMergedSections) {
            ConfigurationPrinter.printSectionSeparator(content, section.getName());
            for (Map.Entry<String, Object> property : section.getProperties().entrySet()) {
                this.printSectionProperty(content, property.getKey(), property.getValue());
            }
        }
    }

    private List<ConfigurationLoggerSection> mergeDuplicatedSections(List<ConfigurationLoggerSection> sections) {
        Map<String, List<ConfigurationLoggerSection>> groupedByNameSections = sections.stream().collect(Collectors.groupingBy(ConfigurationLoggerSection::getName));
        return groupedByNameSections.entrySet().stream().map(this::mergeSectionsGroupedByName).collect(Collectors.toList());
    }

    private InternalConfigurationLoggerSection mergeSectionsGroupedByName(Map.Entry<String, List<ConfigurationLoggerSection>> entry) {
        return entry.getValue().stream().reduce(new InternalConfigurationLoggerSection(entry.getKey()), InternalConfigurationLoggerSection::merge, InternalConfigurationLoggerSection::merge);
    }

    private List<ConfigurationLoggerSection> sortSections(List<ConfigurationLoggerSection> sections) {
        Comparator<ConfigurationLoggerSection> comparator = Comparator.comparing(ConfigurationLoggerSection::getPriority).thenComparing(ConfigurationLoggerSection::getName);
        return sections.stream().sorted(comparator).toList();
    }

    private static void printSectionSeparator(StringBuilder content, String header) {
        int leftPaddingSize = (185 - header.length() - 2) / 2;
        int rightPaddingSize = 185 - (leftPaddingSize + 2 + header.length());
        content.append(SEPARATOR.repeat(leftPaddingSize)).append(" ").append(header).append(" ").append(SEPARATOR.repeat(rightPaddingSize)).append("\n");
    }

    private void printSectionProperty(StringBuilder content, String key, Object value) {
        content.append(FRAME_LEFT).append(StringUtils.leftPad((String)key, (int)89)).append(" : ").append(StringUtils.rightPad((String)String.valueOf(value), (int)89)).append(FRAME_RIGHT).append("\n");
    }

    public ConfigurationPrinter(LogoProvider logoProvider) {
        this.logoProvider = logoProvider;
    }

    private static class InternalConfigurationLoggerSection
    implements ConfigurationLoggerSection {
        private final String name;
        private int priority = Integer.MAX_VALUE;
        private final Map<String, Object> properties = new HashMap<String, Object>();

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public int getPriority() {
            return this.priority;
        }

        @Override
        public Map<String, Object> getProperties() {
            return this.properties;
        }

        private InternalConfigurationLoggerSection merge(ConfigurationLoggerSection section) {
            this.priority = Math.min(this.priority, section.getPriority());
            this.properties.putAll(section.getProperties());
            return this;
        }

        public InternalConfigurationLoggerSection(String name) {
            this.name = name;
        }
    }
}

