/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.common.logger;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Optional;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import pl.decerto.hyperon.common.logger.ApplicationInfoProperties;

class LogoProvider {
    private static final Logger log = LoggerFactory.getLogger(LogoProvider.class);
    private final ResourceLoader resourceLoader;
    private final ApplicationInfoProperties applicationInfoProperties;

    public Optional<String> getLogo() {
        Resource logo = this.resourceLoader.getResource(this.applicationInfoProperties.getLogoPath());
        try {
            if (logo.exists()) {
                String logoContent = IOUtils.toString((InputStream)logo.getInputStream(), (Charset)Charset.defaultCharset());
                return Optional.of(logoContent);
            }
        }
        catch (IOException e) {
            log.warn("Logo not present in path {}!", (Object)this.applicationInfoProperties.getLogoPath(), (Object)e);
        }
        return Optional.empty();
    }

    public LogoProvider(ResourceLoader resourceLoader, ApplicationInfoProperties applicationInfoProperties) {
        this.resourceLoader = resourceLoader;
        this.applicationInfoProperties = applicationInfoProperties;
    }
}

