/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.common.security;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.transaction.annotation.Transactional;
import pl.decerto.hyperon.common.security.MppUserDetails;
import pl.decerto.hyperon.common.security.cache.UsersCacheManager;
import pl.decerto.hyperon.common.security.dao.UserManagementDao;
import pl.decerto.hyperon.common.security.domain.SystemUserJPA;
import pl.decerto.hyperon.common.security.dto.SystemUser;
import pl.decerto.hyperon.common.security.mapper.SystemUserMapper;

public class HigsonUserDetailsService
implements UserDetailsService {
    private static final Logger log = LoggerFactory.getLogger(HigsonUserDetailsService.class);
    private final UserManagementDao usersManagementDao;
    private final UsersCacheManager userCache;
    private final SystemUserMapper userMapper;

    @Transactional
    public MppUserDetails loadUserByUsername(String login) {
        log.trace("enter loadUserByUsername(login={})", (Object)login);
        SystemUserJPA u = this.usersManagementDao.findByLogin(login);
        if (u == null) {
            throw new UsernameNotFoundException(login);
        }
        SystemUser user = this.userMapper.toDto(u);
        return MppUserDetails.createMppUserDetails(user, this.userCache.getUserCacheEntry(login));
    }

    public HigsonUserDetailsService(UserManagementDao usersManagementDao, UsersCacheManager userCache, SystemUserMapper userMapper) {
        this.usersManagementDao = usersManagementDao;
        this.userCache = userCache;
        this.userMapper = userMapper;
    }
}

