/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.common.security;

import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;
import pl.decerto.hyperon.common.security.SystemUserAttributeNotFoundException;
import pl.decerto.hyperon.common.security.UserManagementService;
import pl.decerto.hyperon.common.security.activedirectory.exception.NotUniqueEmailException;
import pl.decerto.hyperon.common.security.dto.SystemUser;
import pl.decerto.hyperon.common.utils.Messages;

@Component
public class SystemUserValidator {
    private final UserManagementService userManagementService;

    public void validate(SystemUser systemUser) {
        String firstName = systemUser.getFirstName();
        if (StringUtils.isEmpty((CharSequence)firstName)) {
            throw new SystemUserAttributeNotFoundException(Messages.message("authentication.external.error.attributeNotFound", "firstname"));
        }
        String surname = systemUser.getLastName();
        if (StringUtils.isEmpty((CharSequence)surname)) {
            throw new SystemUserAttributeNotFoundException(Messages.message("authentication.external.error.attributeNotFound", "surname"));
        }
        String mail = systemUser.getEmail();
        if (StringUtils.isEmpty((CharSequence)mail)) {
            throw new SystemUserAttributeNotFoundException(Messages.message("authentication.external.error.attributeNotFound", "mail"));
        }
        this.validateUniqueMail(systemUser);
    }

    private void validateUniqueMail(SystemUser systemUser) {
        SystemUser userByMail = this.userManagementService.getUserByEmail(systemUser.getEmail());
        if (Objects.isNull(userByMail)) {
            return;
        }
        if (userByMail.getId() != systemUser.getId()) {
            throw new NotUniqueEmailException(Messages.message("authentication.external.error.notUniqueMail"));
        }
    }

    public SystemUserValidator(UserManagementService userManagementService) {
        this.userManagementService = userManagementService;
    }
}

