/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.common.utils.collection;

import jakarta.validation.constraints.NotNull;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class CollectionTools {
    private CollectionTools() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    @NotNull
    public static <E> Set<E> findDuplicatedElements(Iterable<E> iterable) {
        HashSet<E> duplicates = new HashSet<E>();
        if (iterable != null) {
            HashSet<E> elements = new HashSet<E>();
            for (E element : iterable) {
                if (elements.add(element)) continue;
                duplicates.add(element);
            }
        }
        return duplicates;
    }

    public static <E> void addIfNotNull(@NotNull Collection<E> to, E element) {
        if (element != null) {
            to.add(element);
        }
    }

    public static <E> void addAllIfNotNull(@NotNull Collection<E> to, Collection<? extends E> from) {
        if (from != null) {
            to.addAll(from);
        }
    }

    public static <T> List<T> findItemsOfType(Collection<?> collection, @NotNull Class<T> elementClass) {
        if (collection == null) {
            return Collections.emptyList();
        }
        return collection.stream().filter(elementClass::isInstance).map(elementClass::cast).collect(Collectors.toList());
    }
}

