/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.autoconfigure.config.s3;

import io.awspring.cloud.autoconfigure.config.BootstrapLoggingHelper;
import io.awspring.cloud.autoconfigure.config.s3.S3ConfigDataResource;
import io.awspring.cloud.s3.config.S3PropertySource;
import java.util.Collections;
import java.util.Map;
import org.springframework.boot.context.config.ConfigData;
import org.springframework.boot.context.config.ConfigDataLoader;
import org.springframework.boot.context.config.ConfigDataLoaderContext;
import org.springframework.boot.context.config.ConfigDataResource;
import org.springframework.boot.context.config.ConfigDataResourceNotFoundException;
import org.springframework.boot.logging.DeferredLogFactory;
import org.springframework.core.env.MapPropertySource;
import org.springframework.lang.Nullable;
import software.amazon.awssdk.services.s3.S3Client;

public class S3ConfigDataLoader
implements ConfigDataLoader<S3ConfigDataResource> {
    public S3ConfigDataLoader(DeferredLogFactory logFactory) {
        BootstrapLoggingHelper.reconfigureLoggers(logFactory, "io.awspring.cloud.s3.config.S3PropertySource", "io.awspring.cloud.autoconfigure.config.s3.S3PropertySources");
    }

    @Nullable
    public ConfigData load(ConfigDataLoaderContext context, S3ConfigDataResource resource) {
        try {
            if (resource.isEnabled()) {
                S3Client s3Client = (S3Client)context.getBootstrapContext().get(S3Client.class);
                S3PropertySource propertySource = resource.getPropertySources().createPropertySource(resource.getContext(), resource.isOptional(), s3Client);
                if (propertySource != null) {
                    return new ConfigData(Collections.singletonList(propertySource), new ConfigData.Option[0]);
                }
                return null;
            }
            return new ConfigData(Collections.singletonList(new MapPropertySource("aws-s3:" + context, Map.of())), new ConfigData.Option[0]);
        }
        catch (Exception e) {
            throw new ConfigDataResourceNotFoundException((ConfigDataResource)resource, (Throwable)e);
        }
    }
}

