/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.brave.instrument.reactor.netty;

import brave.Span;
import brave.propagation.CurrentTraceContext;
import brave.propagation.TraceContext;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.util.AttributeKey;
import org.springframework.cloud.sleuth.brave.instrument.reactor.netty.TracingHandlerUtil;
import reactor.netty.Connection;
import reactor.netty.ConnectionObserver;
import reactor.netty.channel.ChannelOperations;
import reactor.netty.http.client.HttpClientResponse;

public class TracingChannelInboundHandler
extends ChannelInboundHandlerAdapter {
    static final AttributeKey<Span> SPAN_ATTRIBUTE_KEY = AttributeKey.valueOf((String)Span.class.getName());
    final CurrentTraceContext currentTraceContext;

    public TracingChannelInboundHandler(CurrentTraceContext currentTraceContext) {
        this.currentTraceContext = currentTraceContext;
    }

    public void channelRegistered(ChannelHandlerContext ctx) {
        if (this.instrumentOperation(ctx, () -> ctx.fireChannelRegistered())) {
            return;
        }
        ctx.fireChannelRegistered();
    }

    public void channelUnregistered(ChannelHandlerContext ctx) {
        if (this.instrumentOperation(ctx, () -> ctx.fireChannelUnregistered())) {
            return;
        }
        ctx.fireChannelUnregistered();
    }

    public void channelActive(ChannelHandlerContext ctx) {
        if (this.instrumentOperation(ctx, () -> ctx.fireChannelActive())) {
            return;
        }
        ctx.fireChannelActive();
    }

    public void channelInactive(ChannelHandlerContext ctx) {
        if (this.instrumentOperation(ctx, () -> ctx.fireChannelInactive())) {
            return;
        }
        ctx.fireChannelInactive();
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        if (this.instrumentOperation(ctx, () -> ctx.fireChannelRead(msg))) {
            return;
        }
        ctx.fireChannelRead(msg);
    }

    public void channelReadComplete(ChannelHandlerContext ctx) {
        if (this.instrumentOperation(ctx, () -> ctx.fireChannelReadComplete())) {
            return;
        }
        ctx.fireChannelReadComplete();
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) {
        if (this.instrumentOperation(ctx, () -> ctx.fireUserEventTriggered(evt))) {
            return;
        }
        ctx.fireUserEventTriggered(evt);
    }

    public void channelWritabilityChanged(ChannelHandlerContext ctx) {
        if (this.instrumentOperation(ctx, () -> ctx.fireChannelWritabilityChanged())) {
            return;
        }
        ctx.fireChannelWritabilityChanged();
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        if (this.instrumentOperation(ctx, () -> ctx.fireExceptionCaught(cause))) {
            return;
        }
        ctx.fireExceptionCaught(cause);
    }

    public boolean isSharable() {
        return false;
    }

    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        if (this.instrumentOperation(ctx, () -> {
            try {
                super.handlerAdded(ctx);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        })) {
            return;
        }
        super.handlerAdded(ctx);
    }

    public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
        if (this.instrumentOperation(ctx, () -> {
            try {
                super.handlerRemoved(ctx);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        })) {
            return;
        }
        super.handlerRemoved(ctx);
    }

    boolean instrumentOperation(ChannelHandlerContext ctx, Runnable operation) {
        Span span = (Span)ctx.channel().attr(SPAN_ATTRIBUTE_KEY).get();
        if (span != null) {
            try (CurrentTraceContext.Scope scope = this.currentTraceContext.maybeScope(span.context());){
                operation.run();
            }
            return true;
        }
        Connection conn = Connection.from((Channel)ctx.channel());
        if (conn instanceof ConnectionObserver) {
            TraceContext parent = (TraceContext)((ConnectionObserver)conn).currentContext().getOrDefault(TraceContext.class, null);
            if (parent != null) {
                try (CurrentTraceContext.Scope scope = this.currentTraceContext.maybeScope(parent);){
                    operation.run();
                }
                return true;
            }
        } else {
            TraceContext parent;
            ChannelOperations ops = (ChannelOperations)conn.as(ChannelOperations.class);
            if (ops instanceof HttpClientResponse && (parent = TracingHandlerUtil.traceContext(((HttpClientResponse)ops).currentContextView())) != null) {
                try (CurrentTraceContext.Scope scope = this.currentTraceContext.maybeScope(parent);){
                    operation.run();
                }
                return true;
            }
        }
        return false;
    }
}

