/*
 * Decompiled with CFR 0.152.
 */
package io.higson.runtime.core.datasource;

import io.higson.runtime.core.domain.AttributeValueProvider;
import io.higson.runtime.dao.util.LoadTime;
import io.higson.runtime.model.DomainAttributeDto;
import io.higson.runtime.model.DomainObjectImpl;
import io.higson.runtime.model.DomainObjectTypeImpl;
import io.higson.runtime.model.OpenSession;
import io.higson.runtime.model.ReferenceDto;
import io.higson.runtime.model.RegionVersion;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;

public interface DomainCacheDao {
    public Date getDomainElementLastUpdate();

    public Date getRegionVersionLastUpdate();

    public Date getDomainDefinitionLastUpdate();

    public Map<String, DomainObjectTypeImpl> getTypesByCode(String var1);

    public Integer getCollectionId(int var1);

    public Map<String, DomainObjectImpl> getObjectsById(String var1, int var2, Map<String, DomainObjectTypeImpl> var3, Set<Integer> var4);

    public Map<String, Integer> getNewParents(String var1, Set<Integer> var2);

    public DomainObjectImpl getObjectById(int var1, String var2, DomainObjectTypeImpl var3, AttributeValueProvider var4, Set<Integer> var5);

    public Map<String, List<ReferenceDto>> getReferences(String var1, int var2, Set<Integer> var3);

    public List<ReferenceDto> getReferences(int var1);

    public Map<String, Date> getProfileLastUpdates();

    public Map<String, List<DomainAttributeLoadWrapper>> getObjectsDynamicAttributesByObjectId(String var1, int var2, Set<Integer> var3);

    public Map<String, List<DomainAttributeLoadWrapper>> getObjectsAttributesByObjectId(String var1, int var2, Set<Integer> var3);

    public List<RegionVersion> getUserVersions(String var1, String var2);

    public List<OpenSession> getOpenSessions(String var1, String var2);

    public Date getLastUpdateForProfile(String var1);

    public Date getLastUpdateForOpenSession(String var1, String var2);

    public Date getDefinitionLastUpdateInProfile(String var1);

    public SortedSet<Integer> getSystemVersionWithoutMy(String var1, SortedSet<Integer> var2);

    public static class DomainAttributeLoadWrapper {
        private final DomainAttributeDto dto;
        private final LoadTime loadTime;

        public DomainAttributeDto getDto() {
            return this.dto;
        }

        public LoadTime getLoadTime() {
            return this.loadTime;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DomainAttributeLoadWrapper)) {
                return false;
            }
            DomainAttributeLoadWrapper other = (DomainAttributeLoadWrapper)o;
            if (!other.canEqual(this)) {
                return false;
            }
            DomainAttributeDto this$dto = this.getDto();
            DomainAttributeDto other$dto = other.getDto();
            if (this$dto == null ? other$dto != null : !((Object)this$dto).equals(other$dto)) {
                return false;
            }
            LoadTime this$loadTime = this.getLoadTime();
            LoadTime other$loadTime = other.getLoadTime();
            return !(this$loadTime == null ? other$loadTime != null : !((Object)this$loadTime).equals(other$loadTime));
        }

        protected boolean canEqual(Object other) {
            return other instanceof DomainAttributeLoadWrapper;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            DomainAttributeDto $dto = this.getDto();
            result = result * 59 + ($dto == null ? 43 : ((Object)$dto).hashCode());
            LoadTime $loadTime = this.getLoadTime();
            result = result * 59 + ($loadTime == null ? 43 : ((Object)$loadTime).hashCode());
            return result;
        }

        public DomainAttributeLoadWrapper(DomainAttributeDto dto, LoadTime loadTime) {
            this.dto = dto;
            this.loadTime = loadTime;
        }
    }
}

