/*
 * Decompiled with CFR 0.152.
 */
package io.higson.runtime.core.datasource.snapshot.domain;

import com.google.common.base.Strings;
import java.util.Objects;
import java.util.StringJoiner;
import pl.decerto.mpp.imports.xml.domain.ChildElement;
import pl.decerto.mpp.imports.xml.domain.DomainElement;
import pl.decerto.mpp.imports.xml.domain.DomainType;

public class DomainWrapper {
    private final DomainElement domainElement;
    private final DomainType domainType;
    private final boolean isRootElement;

    private DomainWrapper(DomainElement domainElement, DomainType domainType, boolean isRootElement) {
        this.domainElement = domainElement;
        this.domainType = domainType;
        this.isRootElement = isRootElement;
    }

    static DomainWrapper createWrapperForChildElement(DomainElement domainElement, DomainType domainType) {
        return new DomainWrapper(domainElement, domainType, false);
    }

    static DomainWrapper createWrapperForRootElement(DomainElement domainElement, DomainType domainType) {
        return new DomainWrapper(domainElement, domainType, true);
    }

    void addChildTo(DomainElement childElement) {
        if (this.domainElement.getChildren() == null) {
            this.domainElement.setChildren(new ChildElement());
        }
        if (!Strings.isNullOrEmpty((String)this.domainElement.getRegionCode())) {
            childElement.setRegionCode(this.domainElement.getRegionCode());
        }
        if (!Strings.isNullOrEmpty((String)this.domainElement.getVersionNumber())) {
            childElement.setVersionNumber(this.domainElement.getVersionNumber());
        }
        this.domainElement.getChildren().getChildElement().add(childElement);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DomainWrapper that = (DomainWrapper)o;
        return Objects.equals(this.domainElement.getCode(), that.domainElement.getCode());
    }

    public int hashCode() {
        return Objects.hash(this.domainElement.getCode());
    }

    public String toString() {
        return new StringJoiner(", ", DomainWrapper.class.getSimpleName() + "[", "]").add("domainElement=" + this.domainElement.getCode()).add("domainType=" + this.domainType.getCode()).add("isRootElement=" + this.isRootElement).toString();
    }

    public DomainElement getDomainElement() {
        return this.domainElement;
    }

    public DomainType getDomainType() {
        return this.domainType;
    }

    public boolean isRootElement() {
        return this.isRootElement;
    }
}

