/*
 * Decompiled with CFR 0.152.
 */
package io.higson.runtime.core.datasource.snapshot.parameter;

import io.higson.runtime.core.datasource.snapshot.parameter.ExternalSourceModel;
import io.higson.runtime.core.datasource.snapshot.parameter.ParameterInputLevelModel;
import io.higson.runtime.core.datasource.snapshot.parameter.ParameterOutputLevelModel;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class ParameterModel {
    private String code;
    private String description;
    private boolean nullable;
    private boolean dictionary;
    private boolean cacheable;
    private boolean distinct;
    private String sort;
    private String masterName;
    private ExternalSourceModel externalSource;
    private boolean slave;
    private String label;
    private List<String> categories;
    private List<ParameterInputLevelModel> inputLevel = new ArrayList<ParameterInputLevelModel>();
    private List<ParameterOutputLevelModel> outputLevel = new ArrayList<ParameterOutputLevelModel>();

    public void setCategories(List<String> categories) {
        this.categories = CollectionUtils.isEmpty(categories) ? null : categories;
    }

    public void setInputLevel(List<ParameterInputLevelModel> inputLevel) {
        this.inputLevel = CollectionUtils.isEmpty(inputLevel) ? null : inputLevel;
    }

    public void setOutputLevel(List<ParameterOutputLevelModel> outputLevel) {
        this.outputLevel = CollectionUtils.isEmpty(outputLevel) ? null : outputLevel;
    }

    public ParameterModel trimCode() {
        List<ParameterInputLevelModel> inputs = this.inputLevel.stream().map(input -> {
            String codeToTrim = input.getCode();
            return input.withCode(StringUtils.trim((String)codeToTrim));
        }).collect(Collectors.toList());
        List<ParameterOutputLevelModel> outputs = this.outputLevel.stream().map(output -> {
            String codeToTrim = output.getCode();
            return output.withCode(StringUtils.trim((String)codeToTrim));
        }).collect(Collectors.toList());
        return this.toBuilder().code(StringUtils.trim((String)this.code)).inputLevel(inputs).outputLevel(outputs).build();
    }

    public static ParameterModelBuilder builder() {
        return new ParameterModelBuilder();
    }

    public ParameterModelBuilder toBuilder() {
        return new ParameterModelBuilder().code(this.code).description(this.description).nullable(this.nullable).dictionary(this.dictionary).cacheable(this.cacheable).distinct(this.distinct).sort(this.sort).masterName(this.masterName).externalSource(this.externalSource).slave(this.slave).label(this.label).categories(this.categories).inputLevel(this.inputLevel).outputLevel(this.outputLevel);
    }

    public String getCode() {
        return this.code;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public boolean isDictionary() {
        return this.dictionary;
    }

    public boolean isCacheable() {
        return this.cacheable;
    }

    public boolean isDistinct() {
        return this.distinct;
    }

    public String getSort() {
        return this.sort;
    }

    public String getMasterName() {
        return this.masterName;
    }

    public ExternalSourceModel getExternalSource() {
        return this.externalSource;
    }

    public boolean isSlave() {
        return this.slave;
    }

    public String getLabel() {
        return this.label;
    }

    public List<String> getCategories() {
        return this.categories;
    }

    public List<ParameterInputLevelModel> getInputLevel() {
        return this.inputLevel;
    }

    public List<ParameterOutputLevelModel> getOutputLevel() {
        return this.outputLevel;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setNullable(boolean nullable) {
        this.nullable = nullable;
    }

    public void setDictionary(boolean dictionary) {
        this.dictionary = dictionary;
    }

    public void setCacheable(boolean cacheable) {
        this.cacheable = cacheable;
    }

    public void setDistinct(boolean distinct) {
        this.distinct = distinct;
    }

    public void setSort(String sort) {
        this.sort = sort;
    }

    public void setMasterName(String masterName) {
        this.masterName = masterName;
    }

    public void setExternalSource(ExternalSourceModel externalSource) {
        this.externalSource = externalSource;
    }

    public void setSlave(boolean slave) {
        this.slave = slave;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ParameterModel)) {
            return false;
        }
        ParameterModel other = (ParameterModel)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isNullable() != other.isNullable()) {
            return false;
        }
        if (this.isDictionary() != other.isDictionary()) {
            return false;
        }
        if (this.isCacheable() != other.isCacheable()) {
            return false;
        }
        if (this.isDistinct() != other.isDistinct()) {
            return false;
        }
        String this$code = this.getCode();
        String other$code = other.getCode();
        if (this$code == null ? other$code != null : !this$code.equals(other$code)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$sort = this.getSort();
        String other$sort = other.getSort();
        if (this$sort == null ? other$sort != null : !this$sort.equals(other$sort)) {
            return false;
        }
        String this$masterName = this.getMasterName();
        String other$masterName = other.getMasterName();
        if (this$masterName == null ? other$masterName != null : !this$masterName.equals(other$masterName)) {
            return false;
        }
        ExternalSourceModel this$externalSource = this.getExternalSource();
        ExternalSourceModel other$externalSource = other.getExternalSource();
        if (this$externalSource == null ? other$externalSource != null : !((Object)this$externalSource).equals(other$externalSource)) {
            return false;
        }
        List<String> this$categories = this.getCategories();
        List<String> other$categories = other.getCategories();
        if (this$categories == null ? other$categories != null : !((Object)this$categories).equals(other$categories)) {
            return false;
        }
        List<ParameterInputLevelModel> this$inputLevel = this.getInputLevel();
        List<ParameterInputLevelModel> other$inputLevel = other.getInputLevel();
        if (this$inputLevel == null ? other$inputLevel != null : !((Object)this$inputLevel).equals(other$inputLevel)) {
            return false;
        }
        List<ParameterOutputLevelModel> this$outputLevel = this.getOutputLevel();
        List<ParameterOutputLevelModel> other$outputLevel = other.getOutputLevel();
        return !(this$outputLevel == null ? other$outputLevel != null : !((Object)this$outputLevel).equals(other$outputLevel));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ParameterModel;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isNullable() ? 79 : 97);
        result = result * 59 + (this.isDictionary() ? 79 : 97);
        result = result * 59 + (this.isCacheable() ? 79 : 97);
        result = result * 59 + (this.isDistinct() ? 79 : 97);
        String $code = this.getCode();
        result = result * 59 + ($code == null ? 43 : $code.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $sort = this.getSort();
        result = result * 59 + ($sort == null ? 43 : $sort.hashCode());
        String $masterName = this.getMasterName();
        result = result * 59 + ($masterName == null ? 43 : $masterName.hashCode());
        ExternalSourceModel $externalSource = this.getExternalSource();
        result = result * 59 + ($externalSource == null ? 43 : ((Object)$externalSource).hashCode());
        List<String> $categories = this.getCategories();
        result = result * 59 + ($categories == null ? 43 : ((Object)$categories).hashCode());
        List<ParameterInputLevelModel> $inputLevel = this.getInputLevel();
        result = result * 59 + ($inputLevel == null ? 43 : ((Object)$inputLevel).hashCode());
        List<ParameterOutputLevelModel> $outputLevel = this.getOutputLevel();
        result = result * 59 + ($outputLevel == null ? 43 : ((Object)$outputLevel).hashCode());
        return result;
    }

    public String toString() {
        return "ParameterModel(code=" + this.getCode() + ", description=" + this.getDescription() + ", nullable=" + this.isNullable() + ", dictionary=" + this.isDictionary() + ", cacheable=" + this.isCacheable() + ", distinct=" + this.isDistinct() + ", sort=" + this.getSort() + ", masterName=" + this.getMasterName() + ", externalSource=" + this.getExternalSource() + ", categories=" + this.getCategories() + ", inputLevel=" + this.getInputLevel() + ", outputLevel=" + this.getOutputLevel() + ")";
    }

    public ParameterModel() {
    }

    public ParameterModel(String code, String description, boolean nullable, boolean dictionary, boolean cacheable, boolean distinct, String sort, String masterName, ExternalSourceModel externalSource, boolean slave, String label, List<String> categories, List<ParameterInputLevelModel> inputLevel, List<ParameterOutputLevelModel> outputLevel) {
        this.code = code;
        this.description = description;
        this.nullable = nullable;
        this.dictionary = dictionary;
        this.cacheable = cacheable;
        this.distinct = distinct;
        this.sort = sort;
        this.masterName = masterName;
        this.externalSource = externalSource;
        this.slave = slave;
        this.label = label;
        this.categories = categories;
        this.inputLevel = inputLevel;
        this.outputLevel = outputLevel;
    }

    public static class ParameterModelBuilder {
        private String code;
        private String description;
        private boolean nullable;
        private boolean dictionary;
        private boolean cacheable;
        private boolean distinct;
        private String sort;
        private String masterName;
        private ExternalSourceModel externalSource;
        private boolean slave;
        private String label;
        private List<String> categories;
        private List<ParameterInputLevelModel> inputLevel;
        private List<ParameterOutputLevelModel> outputLevel;

        ParameterModelBuilder() {
        }

        public ParameterModelBuilder code(String code) {
            this.code = code;
            return this;
        }

        public ParameterModelBuilder description(String description) {
            this.description = description;
            return this;
        }

        public ParameterModelBuilder nullable(boolean nullable) {
            this.nullable = nullable;
            return this;
        }

        public ParameterModelBuilder dictionary(boolean dictionary) {
            this.dictionary = dictionary;
            return this;
        }

        public ParameterModelBuilder cacheable(boolean cacheable) {
            this.cacheable = cacheable;
            return this;
        }

        public ParameterModelBuilder distinct(boolean distinct) {
            this.distinct = distinct;
            return this;
        }

        public ParameterModelBuilder sort(String sort) {
            this.sort = sort;
            return this;
        }

        public ParameterModelBuilder masterName(String masterName) {
            this.masterName = masterName;
            return this;
        }

        public ParameterModelBuilder externalSource(ExternalSourceModel externalSource) {
            this.externalSource = externalSource;
            return this;
        }

        public ParameterModelBuilder slave(boolean slave) {
            this.slave = slave;
            return this;
        }

        public ParameterModelBuilder label(String label) {
            this.label = label;
            return this;
        }

        public ParameterModelBuilder categories(List<String> categories) {
            this.categories = categories;
            return this;
        }

        public ParameterModelBuilder inputLevel(List<ParameterInputLevelModel> inputLevel) {
            this.inputLevel = inputLevel;
            return this;
        }

        public ParameterModelBuilder outputLevel(List<ParameterOutputLevelModel> outputLevel) {
            this.outputLevel = outputLevel;
            return this;
        }

        public ParameterModel build() {
            return new ParameterModel(this.code, this.description, this.nullable, this.dictionary, this.cacheable, this.distinct, this.sort, this.masterName, this.externalSource, this.slave, this.label, this.categories, this.inputLevel, this.outputLevel);
        }

        public String toString() {
            return "ParameterModel.ParameterModelBuilder(code=" + this.code + ", description=" + this.description + ", nullable=" + this.nullable + ", dictionary=" + this.dictionary + ", cacheable=" + this.cacheable + ", distinct=" + this.distinct + ", sort=" + this.sort + ", masterName=" + this.masterName + ", externalSource=" + this.externalSource + ", slave=" + this.slave + ", label=" + this.label + ", categories=" + this.categories + ", inputLevel=" + this.inputLevel + ", outputLevel=" + this.outputLevel + ")";
        }
    }
}

