/*
 * Decompiled with CFR 0.152.
 */
package io.higson.runtime.core.versioninterceptor;

import io.higson.runtime.core.versioninterceptor.RuntimeVersionInterceptor;
import io.higson.runtime.core.versioninterceptor.VersionInterceptor;
import io.higson.runtime.dev.DevModePerspective;
import io.higson.runtime.model.region.RegionVersionIdentifier;
import java.util.Date;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeveloperModeInterceptor
implements VersionInterceptor {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final RuntimeVersionInterceptor runtimeInterceptor;
    private final DevModePerspective perspective;
    private final String username;

    public DeveloperModeInterceptor(RuntimeVersionInterceptor versionInterceptor, DevModePerspective perspective, String username) {
        this.runtimeInterceptor = versionInterceptor;
        this.perspective = perspective;
        this.username = username;
    }

    @Override
    public String decorateParameterUid(String parameterName) {
        String uid = this.perspective.decorateParameterName(parameterName, this.username);
        this.log.trace("decorated parameter name: {}", (Object)uid);
        return uid;
    }

    @Override
    public String decorateFunctionUid(String functionName) {
        String uid = this.perspective.decorateFunctionName(functionName, this.username);
        this.log.trace("decorated function name: {}", (Object)uid);
        return uid;
    }

    @Override
    public void setEffectiveVersion(String region, String version) {
        this.runtimeInterceptor.setEffectiveVersion(region, version);
    }

    @Override
    public void setEffectiveVersion(String profileCode, String regionCode, String version) {
        this.runtimeInterceptor.setEffectiveVersion(profileCode, regionCode, version);
    }

    @Override
    public void setEffectiveDate(Date date) {
        this.runtimeInterceptor.setEffectiveDate(date);
    }

    @Override
    public void clearEffectiveVersion(String region) {
        this.runtimeInterceptor.clearEffectiveVersion(region);
    }

    @Override
    public void clearEffectiveVersion(String profileCode, String regionCode) {
        this.runtimeInterceptor.clearEffectiveVersion(profileCode, regionCode);
    }

    @Override
    public void clearEffectiveVersions() {
        this.runtimeInterceptor.clearEffectiveVersions();
    }

    @Override
    public void clearEffectiveDate() {
        this.runtimeInterceptor.clearEffectiveDate();
    }

    @Override
    public void clearEffectiveSetup() {
        this.runtimeInterceptor.clearEffectiveSetup();
    }

    @Override
    public Optional<Date> getEffectiveDate() {
        return this.runtimeInterceptor.getEffectiveDate();
    }

    @Override
    public Set<RegionVersionIdentifier> getEffectiveVersions(String profileCode) {
        return this.runtimeInterceptor.getEffectiveVersions(profileCode);
    }
}

