/*
 * Decompiled with CFR 0.152.
 */
package io.higson.runtime.dao;

import io.higson.runtime.dao.exception.EmptyResultDaoException;
import io.higson.runtime.dao.util.ConnectionInterceptor;
import io.higson.runtime.dao.util.RowCallbackHandler;
import io.higson.runtime.dao.util.RowMapper;
import io.higson.runtime.exception.HigsonRuntimeException;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import javax.sql.DataSource;
import org.apache.commons.dbutils.DbUtils;
import org.apache.commons.lang3.mutable.MutableInt;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MiniJdbcTemplate {
    private static final Logger log = LoggerFactory.getLogger(MiniJdbcTemplate.class);
    private final DataSource dataSource;
    private final ConnectionInterceptor connectionInterceptor;
    private int fetchSize = 0;

    public MiniJdbcTemplate(DataSource dataSource, ConnectionInterceptor connectionInterceptor) {
        this.dataSource = dataSource;
        this.connectionInterceptor = connectionInterceptor;
    }

    public void setFetchSize(int fetchSize) {
        this.fetchSize = fetchSize;
    }

    public void query(String sql, RowCallbackHandler handler) {
        this.query(sql, handler, (Object[])null);
    }

    public void query(String sql, Object[] params, RowCallbackHandler handler) {
        this.query(sql, handler, params);
    }

    public void query(String sql, RowCallbackHandler handler, Object ... params) {
        Connection conn = null;
        PreparedStatement preparedStatement = null;
        ResultSet rs = null;
        try {
            conn = this.connectionInterceptor.getConnection(this.dataSource);
            preparedStatement = this.prepareStatement(conn, sql, params);
            rs = preparedStatement.executeQuery();
            while (rs.next()) {
                handler.processRow(rs);
            }
        }
        catch (SQLException e) {
            try {
                throw new HigsonRuntimeException("failed to execute query", e);
            }
            catch (Throwable throwable) {
                DbUtils.closeQuietly(null, preparedStatement, rs);
                this.connectionInterceptor.releaseConnection(conn);
                throw throwable;
            }
        }
        DbUtils.closeQuietly(null, (Statement)preparedStatement, (ResultSet)rs);
        this.connectionInterceptor.releaseConnection(conn);
    }

    private PreparedStatement prepareStatement(Connection conn, String sql, Object ... params) throws SQLException {
        boolean trace = log.isTraceEnabled();
        if (trace) {
            log.trace("SQL={}", (Object)sql);
        }
        PreparedStatement preparedStatement = conn.prepareStatement(sql);
        if (this.fetchSize > 0) {
            preparedStatement.setFetchSize(this.fetchSize);
        }
        if (params != null) {
            MutableInt idx = new MutableInt(1);
            this.bindParam(idx, preparedStatement, params, trace);
        }
        return preparedStatement;
    }

    private void bindParam(MutableInt idx, PreparedStatement preparedStatement, Object[] params, boolean trace) throws SQLException {
        for (Object param : params) {
            if (param == null) {
                preparedStatement.setNull(idx.getAndIncrement(), Integer.MIN_VALUE);
                continue;
            }
            if (trace) {
                log.trace("binding param: {}/{}", param.getClass(), param);
            }
            if (param instanceof String) {
                preparedStatement.setString(idx.getAndIncrement(), (String)param);
                continue;
            }
            if (param instanceof Integer) {
                preparedStatement.setInt(idx.getAndIncrement(), (Integer)param);
                continue;
            }
            if (param instanceof Long) {
                preparedStatement.setLong(idx.getAndIncrement(), (Long)param);
                continue;
            }
            if (param instanceof Date) {
                preparedStatement.setDate(idx.getAndIncrement(), (Date)param);
                continue;
            }
            if (param instanceof Object[]) {
                this.bindParam(idx, preparedStatement, (Object[])param, trace);
                continue;
            }
            preparedStatement.setObject(idx.getAndIncrement(), param);
        }
    }

    public <T> List<T> query(String sql, RowMapper<T> rowMapper) {
        return this.query(sql, rowMapper, (Object[])null);
    }

    public <T> List<T> query(String sql, Object[] params, RowMapper<T> rowMapper) {
        return this.query(sql, rowMapper, params);
    }

    public <T> List<T> query(String sql, RowMapper<T> rowMapper, Object ... params) {
        ArrayList<T> arrayList;
        ArrayList<T> result = new ArrayList<T>();
        Connection conn = null;
        PreparedStatement preparedStatement = null;
        ResultSet rs = null;
        try {
            conn = this.connectionInterceptor.getConnection(this.dataSource);
            preparedStatement = this.prepareStatement(conn, sql, params);
            rs = preparedStatement.executeQuery();
            int idx = 0;
            while (rs.next()) {
                result.add(rowMapper.mapRow(rs, idx++));
            }
            arrayList = result;
        }
        catch (SQLException e) {
            try {
                throw new HigsonRuntimeException("failed to execute query: \n" + sql, e);
            }
            catch (Throwable throwable) {
                DbUtils.closeQuietly(null, preparedStatement, rs);
                this.connectionInterceptor.releaseConnection(conn);
                throw throwable;
            }
        }
        DbUtils.closeQuietly(null, (Statement)preparedStatement, (ResultSet)rs);
        this.connectionInterceptor.releaseConnection(conn);
        return arrayList;
    }

    public <T> T queryForObject(String sql, Class<T> requiredType) {
        return this.queryForObject(sql, requiredType, null);
    }

    public <T> T queryForObject(String sql, Class<T> requiredType, Object ... params) {
        ResultSet rs;
        PreparedStatement preparedStatement;
        Connection conn;
        block11: {
            Comparable<java.util.Date> result;
            conn = null;
            preparedStatement = null;
            rs = null;
            conn = this.connectionInterceptor.getConnection(this.dataSource);
            preparedStatement = this.prepareStatement(conn, sql, params);
            rs = preparedStatement.executeQuery();
            if (!rs.next()) break block11;
            if (requiredType == java.util.Date.class) {
                Timestamp t = rs.getTimestamp(1);
                result = t != null ? new java.util.Date(t.getTime()) : null;
            } else if (requiredType == Integer.class) {
                result = rs.getInt(1);
                if (rs.wasNull()) {
                    result = null;
                }
            } else {
                throw new HigsonRuntimeException("unsupported fieldType: " + requiredType.getName());
            }
            if (rs.next()) {
                throw new HigsonRuntimeException("Expected one result, found more");
            }
            Comparable<java.util.Date> comparable = result;
            DbUtils.closeQuietly(null, (Statement)preparedStatement, (ResultSet)rs);
            this.connectionInterceptor.releaseConnection(conn);
            return (T)comparable;
        }
        try {
            try {
                throw new EmptyResultDaoException();
            }
            catch (SQLException e) {
                throw new HigsonRuntimeException("failed to execute query: \n" + sql, e);
            }
        }
        catch (Throwable throwable) {
            DbUtils.closeQuietly(null, preparedStatement, rs);
            this.connectionInterceptor.releaseConnection(conn);
            throw throwable;
        }
    }
}

