/*
 * Decompiled with CFR 0.152.
 */
package io.higson.runtime.engine.matchers;

import io.higson.runtime.engine.core.matcher.Matcher;
import io.higson.runtime.engine.core.type.Type;
import io.higson.runtime.engine.core.type.ValueHolder;
import io.higson.runtime.engine.matchers.BetweenMatcherTokenSeparator;
import io.higson.runtime.engine.matchers.RangeToken;
import io.higson.runtime.helper.LevelConstants;

public class BetweenMatcher
implements Matcher {
    private final boolean lowerInclusive;
    private final boolean upperInclusive;
    private final BetweenMatcherTokenSeparator tokenSeparator;

    public BetweenMatcher(boolean lowerInclusive, boolean upperInclusive, BetweenMatcherTokenSeparator tokenSeparator) {
        this.lowerInclusive = lowerInclusive;
        this.upperInclusive = upperInclusive;
        this.tokenSeparator = tokenSeparator;
    }

    public BetweenMatcher(boolean lowerInclusive, boolean upperInclusive, String separators) {
        this(lowerInclusive, upperInclusive, new BetweenMatcherTokenSeparator(separators));
    }

    public BetweenMatcher(boolean lowerInclusive, boolean upperInclusive) {
        this(lowerInclusive, upperInclusive, new BetweenMatcherTokenSeparator());
    }

    @Override
    public <T extends ValueHolder> boolean matches(String value, String pattern, Type<T> type) {
        RangeToken rangeToken = this.tokenSeparator.separate(pattern, type);
        T v = type.decode(value);
        return this.lowerCondition(v, rangeToken.getLower(), type) && this.upperCondition(v, rangeToken.getUpper(), type);
    }

    private <T extends ValueHolder> boolean lowerCondition(T v, String lower, Type<T> type) {
        return this.checkCondition(v, lower, type, false);
    }

    private <T extends ValueHolder> boolean upperCondition(T v, String upper, Type<T> type) {
        return this.checkCondition(v, upper, type, true);
    }

    private <T extends ValueHolder> boolean checkCondition(T v, String boundary, Type<T> type, boolean upper) {
        if (LevelConstants.ASTERISK.getValue().equals(boundary) || "".equals(boundary)) {
            return true;
        }
        T u = type.decode(boundary);
        if (upper) {
            return this.upperInclusive ? v.compareTo(u) <= 0 : v.compareTo(u) < 0;
        }
        return this.lowerInclusive ? u.compareTo(v) <= 0 : u.compareTo(v) < 0;
    }

    public BetweenMatcherTokenSeparator tokenSeparator() {
        return this.tokenSeparator;
    }
}

