/*
 * Decompiled with CFR 0.152.
 */
package io.higson.runtime.engine.matchers;

import io.higson.runtime.engine.core.type.Type;
import io.higson.runtime.engine.core.type.ValueHolder;
import io.higson.runtime.engine.matchers.BasicTokenSeparator;
import io.higson.runtime.engine.matchers.NumericTokenSeparator;
import io.higson.runtime.engine.matchers.RangeToken;
import io.higson.runtime.engine.matchers.TokenSeparator;
import io.higson.runtime.engine.types.integer.IntegerType;
import io.higson.runtime.engine.types.number.NumberType;
import io.higson.runtime.helper.parser.LimitCache;
import org.apache.commons.lang3.StringUtils;

public class BetweenMatcherTokenSeparator {
    private static final int DEFAULT_CACHE_SIZE = 256;
    private static final String[] DEFAULT_SEPARATORS = new String[]{":", "-"};
    private static final String DEFAULT_SEPARATORS_JOINED = String.join((CharSequence)"", DEFAULT_SEPARATORS);
    private final String[] separators;
    private final char firstSeparator;
    private final NumericTokenSeparator numericTokenSeparator;
    private final BasicTokenSeparator basicTokenSeparator;
    private final LimitCache<CacheKey, RangeToken> cache;

    public BetweenMatcherTokenSeparator(String separators, int cacheSize) {
        this.separators = this.readSeparators(separators);
        this.firstSeparator = this.resolveFirstSeparator();
        this.numericTokenSeparator = new NumericTokenSeparator(this.separators);
        this.basicTokenSeparator = new BasicTokenSeparator(this.separators);
        this.cache = new LimitCache("between-matcher", cacheSize);
    }

    public BetweenMatcherTokenSeparator(int cacheSize) {
        this(DEFAULT_SEPARATORS_JOINED, cacheSize);
    }

    public BetweenMatcherTokenSeparator(String separators) {
        this(separators, 256);
    }

    public BetweenMatcherTokenSeparator() {
        this(256);
    }

    public <T extends ValueHolder> RangeToken separate(String pattern, Type<T> type) {
        CacheKey key = new CacheKey(pattern, type.getClass());
        RangeToken result = this.cache.get(key);
        if (result == null) {
            result = this.parse(pattern, type);
            this.cache.put(key, result);
        }
        return result;
    }

    private RangeToken parse(String pattern, Type<?> type) {
        if (StringUtils.isBlank((CharSequence)pattern)) {
            return new RangeToken("", "", this.firstSeparator);
        }
        if (!StringUtils.containsAny((CharSequence)pattern, (CharSequence[])this.separators)) {
            return new RangeToken(pattern.trim(), "", this.firstSeparator);
        }
        return this.getTokenSeparator(type).separate(pattern);
    }

    private char resolveFirstSeparator() {
        return this.separators[0].charAt(0);
    }

    private TokenSeparator getTokenSeparator(Type<?> type) {
        return type instanceof NumberType || type instanceof IntegerType ? this.numericTokenSeparator : this.basicTokenSeparator;
    }

    private String[] readSeparators(String separators) {
        return separators == null || separators.isBlank() ? DEFAULT_SEPARATORS : separators.split("");
    }

    private record CacheKey(String pattern, Class<?> clazz) {
    }
}

