/*
 * Decompiled with CFR 0.152.
 */
package io.higson.runtime.engine.types.date;

public abstract class AbstractDateType<T> {
    private static String defaultOutputPattern = "yyyy-MM-dd";
    private static final int IX2 = 2;
    private static final int IX5 = 5;
    private static final int IX4 = 4;
    private static final int IX7 = 7;
    private static final int DATESTR_LENGTH = 10;

    protected abstract T parse(String var1, String var2);

    protected T guess(String text) {
        String dateStr = text.trim();
        if (dateStr.length() == 10) {
            char c2;
            char c1 = dateStr.charAt(2);
            if (this.bothEqualTo(c1, c2 = dateStr.charAt(5), '-')) {
                return this.parse(dateStr, "dd-MM-yyyy");
            }
            if (this.bothEqualTo(c1, c2, '.')) {
                return this.parse(dateStr, "dd.MM.yyyy");
            }
            if (this.bothEqualTo(c1, c2, '/')) {
                return this.parse(dateStr, "dd/MM/yyyy");
            }
            c1 = dateStr.charAt(4);
            if (this.bothEqualTo(c1, c2 = dateStr.charAt(7), '-')) {
                return this.parse(dateStr, "yyyy-MM-dd");
            }
            if (this.bothEqualTo(c1, c2, '.')) {
                return this.parse(dateStr, "yyyy.MM.dd");
            }
            if (this.bothEqualTo(c1, c2, '/')) {
                return this.parse(dateStr, "yyyy/MM/dd");
            }
        }
        throw new IllegalArgumentException("Unknown date format: [" + dateStr + "]");
    }

    private boolean bothEqualTo(char c1, char c2, char expected) {
        return c1 == expected && c2 == expected;
    }

    public static void setDefaultOutputPattern(String pattern) {
        defaultOutputPattern = pattern;
    }

    public static String getDefaultOutputPattern() {
        return defaultOutputPattern;
    }
}

