/*
 * Decompiled with CFR 0.152.
 */
package io.higson.runtime.engine.types.integer;

import io.higson.runtime.engine.annotated.annotations.ParamType;
import io.higson.runtime.engine.core.type.Type;
import io.higson.runtime.engine.types.integer.IntegerHolder;
import io.higson.runtime.engine.util.EngineUtil;
import org.apache.commons.lang3.StringUtils;

@ParamType(value="integer")
public class IntegerType
implements Type<IntegerHolder> {
    @Override
    public String encode(IntegerHolder holder) {
        Long v = holder.getValue();
        return v != null ? v.toString() : null;
    }

    @Override
    public IntegerHolder decode(String text) {
        Long value = EngineUtil.hasText(text) ? Long.valueOf(text.trim()) : null;
        return new IntegerHolder(value);
    }

    @Override
    public IntegerHolder convert(Object obj) {
        if (obj instanceof Long || obj instanceof Integer || obj instanceof Short || obj instanceof Byte) {
            Number n = (Number)obj;
            return new IntegerHolder(n.longValue());
        }
        if (obj == null) {
            return new IntegerHolder(null);
        }
        if (obj instanceof String) {
            return this.decode((String)obj);
        }
        throw new IllegalArgumentException("conversion not supported for: " + obj.getClass());
    }

    public IntegerHolder[] newArray(int size) {
        return new IntegerHolder[size];
    }

    public boolean canDecode(String text) {
        return text != null && !text.isBlank() && StringUtils.removeStart((String)text.trim(), (String)"-").chars().allMatch(Character::isDigit);
    }
}

