/*
 * Decompiled with CFR 0.152.
 */
package io.higson.runtime.engine.util.reflection;

import io.higson.runtime.engine.util.reflection.InnerReflectiveOperationException;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public final class AnnotationHelper {
    private AnnotationHelper() {
        throw new UnsupportedOperationException();
    }

    public static <T> T extractValue(Annotation annotation, String methodName) {
        try {
            Method defaultValueMethod = annotation.annotationType().getMethod(methodName, new Class[0]);
            return (T)defaultValueMethod.invoke((Object)annotation, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException illegalAccessException) {
            throw AnnotationHelper.reflectiveException(illegalAccessException, methodName, annotation);
        }
    }

    private static InnerReflectiveOperationException reflectiveException(Exception exception, String methodName, Annotation annotation) {
        return new InnerReflectiveOperationException(exception, String.format("No %s method found on annotation %s.", methodName, annotation.annotationType().getCanonicalName()));
    }
}

