/*
 * Decompiled with CFR 0.152.
 */
package io.higson.runtime.helper.parser;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LimitCache<K, V> {
    private static final Logger log = LoggerFactory.getLogger(LimitCache.class);
    private static final int DEFAULT_MAX = 256;
    private final Map<K, V> cache;
    private final String name;
    private volatile int maxSize;
    private volatile boolean open = true;

    public LimitCache(String name, int maxSize) {
        this.name = name;
        this.maxSize = maxSize;
        this.cache = new ConcurrentHashMap(maxSize);
        log.info("cache created: {}", (Object)this);
    }

    public LimitCache(String name) {
        this(name, 256);
    }

    public void put(K key, V value) {
        if (this.open) {
            this.cache.put(key, value);
            if (this.size() >= this.maxSize) {
                this.open = false;
            }
        }
    }

    public V get(K key) {
        return this.cache.get(key);
    }

    public int size() {
        return this.cache.size();
    }

    public boolean isOpen() {
        return this.open;
    }

    public String getName() {
        return this.name;
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public void setMaxSize(int maxSize) {
        if (maxSize < this.size()) {
            this.cache.clear();
        }
        this.maxSize = maxSize;
        this.open = true;
        log.info("cache modified: {}", (Object)this);
    }

    public String toString() {
        return "LimitCache[" + this.name + ": use=" + this.size() + "/" + this.maxSize + ", open=" + this.open + "]";
    }
}

