/*
 * Decompiled with CFR 0.152.
 */
package io.higson.runtime.model;

import io.higson.runtime.function.log.FunctionLogLevel;
import io.higson.runtime.model.Function;
import io.higson.runtime.utils.hash.HashUtils;
import java.util.Date;

public class PythonFunction
extends Function {
    private static final String TYPE = "python";
    private final String args;
    private final String body;

    public PythonFunction(int id, int implId, String code, String args, String body) {
        super(id, implId, code, TYPE);
        this.args = args;
        this.body = body;
    }

    public PythonFunction(int id, int implId, String code, String args, String body, Date lastUpdate, FunctionLogLevel logLevel) {
        super(id, implId, code, TYPE, lastUpdate, logLevel);
        this.args = args;
        this.body = body;
    }

    @Override
    public String getDigest() {
        String[] data = new String[]{this.getCode(), this.getType(), this.body};
        return HashUtils.sha1(data);
    }

    @Override
    public String getArgs() {
        return this.args;
    }

    public String getBody() {
        return this.body;
    }
}

