/*
 * Decompiled with CFR 0.152.
 */
package io.higson.runtime.sorter;

import io.higson.runtime.sorter.SortColumn;
import io.higson.runtime.sorter.SortConfig;
import io.higson.runtime.sorter.SortConfigValidationResult;
import io.higson.runtime.sorter.SortOrder;
import io.higson.runtime.sorter.exception.RuntimeSortConfigException;
import io.higson.runtime.sorter.exception.SortConfigErrorcode;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SortConfigParser {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final Map<String, Integer> code2index = new TreeMap<String, Integer>();
    private final String text;

    public SortConfigParser(String text, Map<String, Integer> code2index) {
        this.text = text;
        for (Map.Entry<String, Integer> e : code2index.entrySet()) {
            this.code2index.put(e.getKey().toLowerCase(), e.getValue());
        }
    }

    public SortConfigParser(String text, List<String> outputCodes) {
        this.text = text;
        for (int i = 0; i < outputCodes.size(); ++i) {
            this.code2index.put(outputCodes.get(i).toLowerCase(), i);
        }
    }

    public SortConfig parse() {
        if (StringUtils.isBlank((CharSequence)this.text)) {
            return null;
        }
        String[] tokens = StringUtils.split((String)this.text, (char)',');
        ArrayList<SortColumn> columns = new ArrayList<SortColumn>(tokens.length);
        for (String token : tokens) {
            columns.add(this.parseColumnToken(token));
        }
        return new SortConfig(columns);
    }

    public SortConfig parseSafe() {
        try {
            return this.parse();
        }
        catch (RuntimeException e) {
            this.log.error("failed to parse sort config: " + this.text, (Throwable)e);
            return null;
        }
    }

    SortColumn parseColumnToken(String coltext) {
        if (StringUtils.isBlank((CharSequence)coltext)) {
            throw new RuntimeSortConfigException("Bad sort syntax", this.text, SortConfigErrorcode.BAD_SYNTAX);
        }
        String[] tokens = StringUtils.split((String)coltext.trim(), (char)' ');
        String name = tokens[0];
        Integer outNo = this.guessColumnNo(name);
        if (outNo == null) {
            this.log.error("bad sort config, unknown column name: {} in config: {}", (Object)name, (Object)this.text);
            throw new RuntimeSortConfigException("Unknown level code", name, SortConfigErrorcode.UNKNOWN_COLUMN);
        }
        SortColumn sortColumn = new SortColumn(name, outNo);
        for (int i = 1; i < tokens.length; ++i) {
            String token = tokens[i];
            this.checkToken(token, sortColumn);
        }
        return sortColumn;
    }

    private Integer guessColumnNo(String token) {
        String name = token.toLowerCase();
        Integer outNo = this.code2index.get(name);
        if (outNo == null) {
            outNo = this.code2index.get(name.replace('.', ' '));
        }
        if (outNo == null) {
            outNo = this.code2index.get(name.replace('_', ' '));
        }
        return outNo;
    }

    private void checkToken(String token, SortColumn sortColumn) {
        if (token.equalsIgnoreCase("asc")) {
            sortColumn.setOrder(SortOrder.ASC);
        } else if (token.equalsIgnoreCase("desc")) {
            sortColumn.setOrder(SortOrder.DESC);
        } else if (token.equalsIgnoreCase("text")) {
            sortColumn.setText(true);
        } else if (token.equalsIgnoreCase("sensitive")) {
            sortColumn.setIgnoreCase(false);
        } else {
            sortColumn.setLocale(new Locale(token));
        }
    }

    public SortConfigValidationResult validate() {
        SortConfigValidationResult result = new SortConfigValidationResult();
        try {
            this.parse();
        }
        catch (RuntimeException e) {
            result.error(e);
        }
        return result;
    }
}

