/*
 * Decompiled with CFR 0.152.
 */
package io.higson.runtime.sync;

import io.higson.runtime.core.datasource.SessionDao;
import io.higson.runtime.dev.DevModeProvider;
import io.higson.runtime.engine.core.prepared.CacheEntry;
import io.higson.runtime.engine.core.prepared.PreparedParamCache;
import io.higson.runtime.engine.core.prepared.PreparedParameter;
import io.higson.runtime.model.Parameter;
import io.higson.runtime.provider.MpParameterProvider;
import io.higson.runtime.reload.NopReloader;
import io.higson.runtime.reload.Reloader;
import io.higson.runtime.sync.RuntimeWatcher;
import io.higson.runtime.sync.Trackable;
import io.higson.runtime.sync.event.ElementType;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Optional;

public class ParamRuntimeWatcher
extends RuntimeWatcher {
    private final MpParameterProvider provider;
    private final PreparedParamCache indexCache;
    private final boolean developerMode;
    private final DevModeProvider devModeProvider;
    private final SessionDao sessionDao;
    private final Reloader reloader;
    private long sessionTimestamp;
    private long lastSyncTimestamp;

    public ParamRuntimeWatcher(MpParameterProvider provider, PreparedParamCache indexCache, DevModeProvider devModeProvider, SessionDao sessionDao, Reloader reloader) {
        this.provider = provider;
        this.indexCache = indexCache;
        this.developerMode = devModeProvider != null;
        this.devModeProvider = devModeProvider;
        this.sessionDao = sessionDao;
        this.lastSyncTimestamp = this.systime();
        this.reloader = reloader;
    }

    public ParamRuntimeWatcher(MpParameterProvider provider, PreparedParamCache indexCache, DevModeProvider devModeProvider, SessionDao sessionDao) {
        this(provider, indexCache, devModeProvider, sessionDao, new NopReloader());
    }

    public ParamRuntimeWatcher(MpParameterProvider provider, PreparedParamCache indexCache) {
        this(provider, indexCache, null, null);
    }

    @Override
    protected String getWatcherName() {
        return "param-watcher";
    }

    @Override
    public void doWatch() {
        if (this.log.isDebugEnabled()) {
            this.log.debug("checking cache accuracy, pt={}, st={}", (Object)this.print(this.timestamp), (Object)this.print(this.sessionTimestamp));
        }
        long sessionMaxLastUpdate = this.getSessionMaxLastUpdate();
        this.lastUpdate = this.getLastUpdate();
        boolean sync = false;
        if (sessionMaxLastUpdate > this.sessionTimestamp) {
            this.log.debug("detected new session LU: {}", (Object)this.print(sessionMaxLastUpdate));
            this.invalidateDevModeCache();
            sync = true;
        }
        if (this.possibleModification()) {
            this.log.debug("detected new parameter LU: {}", (Object)this.print(this.lastUpdate));
            sync = true;
        }
        if (this.shouldForceCacheSync()) {
            this.log.debug("forcing cache sync, last sync: {}", (Object)this.print(this.lastSyncTimestamp));
            sync = true;
        }
        if (sync) {
            this.checkPossibleModification();
            this.lastSyncTimestamp = this.systime();
        }
        this.timestamp = this.lastUpdate;
        this.sessionTimestamp = sessionMaxLastUpdate;
        if (this.log.isDebugEnabled()) {
            this.log.debug("checking cache accuracy finished, pt={}, st={}", (Object)this.print(this.timestamp), (Object)this.print(this.sessionTimestamp));
        }
    }

    private long getSessionMaxLastUpdate() {
        Date maxLastUpdate = this.sessionDao != null ? this.sessionDao.getMaxLastUpdate() : null;
        return maxLastUpdate != null ? maxLastUpdate.getTime() : 0L;
    }

    @Override
    public Date getLastUpdate() {
        return this.provider.getLastUpdate(this.developerMode);
    }

    @Override
    public List<Trackable> getAllLastUpdates() {
        return this.provider.getAllLastUpdates(this.developerMode);
    }

    @Override
    public List<Trackable> getAllCached() {
        List<CacheEntry<PreparedParameter>> all = this.indexCache.list();
        this.log.trace("fetched {} parameters from cache", (Object)all.size());
        ArrayList<Trackable> result = new ArrayList<Trackable>(all.size());
        for (CacheEntry<PreparedParameter> entry : all) {
            String key = entry.getKey();
            this.getMetadata(entry.getValue()).map(metadata -> new Trackable(metadata.getId(), key, metadata.getLastUpdate())).ifPresent(result::add);
        }
        return result;
    }

    @Override
    boolean isChanged(Trackable cached, Trackable fresh) {
        return super.isChanged(cached, fresh) || this.isMasterChanged(cached);
    }

    private boolean isMasterChanged(Trackable cached) {
        return this.getCachedParameter(cached).map(cachedParam -> cachedParam.isSlave() && this.wasMasterModifiedAfterSlaveWasLoaded((Parameter)cachedParam)).orElse(true);
    }

    private Optional<Parameter> getCachedParameter(Trackable cached) {
        return this.getMetadata(this.indexCache.get(cached.getCode()));
    }

    private boolean wasMasterModifiedAfterSlaveWasLoaded(Parameter slave) {
        Trackable master;
        this.log.debug("check if master was updated after slave was loaded: {}", (Object)slave);
        int mid = slave.getMid();
        if (mid > 0) {
            master = this.findDbParam(mid);
            this.log.debug("found master: {}", (Object)master);
            if (master == null) {
                this.log.info("master with pid={} not found, invalidating slave: {}", (Object)mid, (Object)slave);
                return true;
            }
            if (this.masterUpdatedAfterSlaveLoaded(master, slave)) {
                this.log.info("master with pid={} modified after slave was loaded, invalidating slave: {}", (Object)mid, (Object)slave);
                return true;
            }
        }
        if ((master = this.findDbParamWithMaxLastUpdate(slave.getMasterName())) == null || master.getLastUpdate().getTime() > slave.getLoadedAtMillis()) {
            this.log.info("found master modified after slave was loaded: {} / {}", (Object)master, (Object)slave);
            return true;
        }
        return false;
    }

    private Trackable findDbParam(int pid) {
        return this.allFresh.stream().filter(p -> p.getId() == pid).findFirst().orElse(null);
    }

    private Trackable findDbParamWithMaxLastUpdate(String name) {
        return this.allFresh.stream().filter(p -> p.getCode().equals(name)).max(Comparator.comparing(p -> p.getLastUpdate().getTime())).orElse(null);
    }

    private boolean masterUpdatedAfterSlaveLoaded(Trackable master, Parameter slave) {
        Date masterLastUpdate = master.getLastUpdate();
        Date slaveLoadedAt = slave.getLoadedAt();
        if (this.log.isTraceEnabled()) {
            this.log.trace("master LU: {}, slave LA: {}", (Object)this.print(masterLastUpdate), (Object)this.print(slaveLoadedAt));
        }
        return masterLastUpdate.getTime() > slaveLoadedAt.getTime();
    }

    private Optional<Parameter> getMetadata(PreparedParameter parameter) {
        return Optional.ofNullable(parameter).map(mp -> (Parameter)mp.getMetadata());
    }

    @Override
    public void invalidate(int id) {
        this.indexCache.invalidate(id);
    }

    @Override
    public void reload(int id) {
        this.reloader.reloadParameter(id);
    }

    @Override
    public ElementType getElementType() {
        return ElementType.PARAMETER;
    }

    private long systime() {
        return System.currentTimeMillis();
    }

    private boolean shouldForceCacheSync() {
        return this.systime() - this.lastSyncTimestamp > this.config.getForcePauseMillis();
    }

    private void invalidateDevModeCache() {
        if (this.devModeProvider != null) {
            this.devModeProvider.invalidateSessionCache();
        }
    }
}

