/*
 * Decompiled with CFR 0.152.
 */
package io.higson.runtime.utils.hash;

import io.higson.runtime.exception.HigsonRuntimeException;
import io.higson.runtime.utils.hash.DigestAlgorithm;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;

public abstract class DigestAlgorithmPool {
    private static ThreadLocal<Map<String, MessageDigest>> pool = ThreadLocal.withInitial(HashMap::new);

    private DigestAlgorithmPool() {
        throw new UnsupportedOperationException("util class");
    }

    public static MessageDigest get(DigestAlgorithm algo) {
        return DigestAlgorithmPool.get(algo.code());
    }

    public static MessageDigest get(String algorithm) {
        Map<String, MessageDigest> map = pool.get();
        MessageDigest digest = map.get(algorithm);
        if (digest == null) {
            digest = DigestAlgorithmPool.getAlgorithm(algorithm);
            map.put(algorithm, digest);
        }
        return digest;
    }

    private static MessageDigest getAlgorithm(String algorithm) {
        try {
            return MessageDigest.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new HigsonRuntimeException("failed to obtain " + algorithm + " algorithm from JVM", e);
        }
    }
}

