/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.runtime.core.domain;

import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.decerto.hyperon.runtime.core.domain.DomainCache;
import pl.decerto.hyperon.runtime.core.domain.DomainCacheManager;
import pl.decerto.hyperon.runtime.core.domain.MpUserSessionProvider;
import pl.decerto.hyperon.runtime.core.versioninterceptor.EffectiveVersionConfiguration;
import pl.decerto.hyperon.runtime.dao.VersionJdbcDao;
import pl.decerto.hyperon.runtime.model.HyperonDomainObject;
import pl.decerto.hyperon.runtime.model.RegionVersion;

public class MpDomainCache
implements DomainCache {
    private static final Logger log = LoggerFactory.getLogger(MpDomainCache.class);
    protected DomainCacheManager domainCacheManager;
    protected MpUserSessionProvider sessionProvider;
    protected VersionJdbcDao versionDao;

    @Override
    public void setup(DomainCacheManager manager) {
        this.domainCacheManager = manager;
    }

    @Override
    public void setUserSessionProvider(MpUserSessionProvider sessionProvider) {
        this.sessionProvider = sessionProvider;
    }

    @Override
    public void setVersionJdbcDao(VersionJdbcDao versionDao) {
        this.versionDao = versionDao;
    }

    @Override
    public Set<String> getProfiles() {
        log.trace("enter getProfiles()");
        return this.domainCacheManager.getProfiles();
    }

    @Override
    public HyperonDomainObject getDomain(String profileCode, String objectPath) {
        return this.getDomain(profileCode, objectPath, null);
    }

    @Override
    public HyperonDomainObject getDomainWithAllVersions(String profileCode, String objectPath) {
        List<RegionVersion> versions = this.versionDao.getAllRegionVersionsList(profileCode);
        return this.getDomainWithAllVersions(profileCode, objectPath, versions);
    }

    @Override
    public HyperonDomainObject getDomain(String profileCode, String objectPath, EffectiveVersionConfiguration configuration) {
        log.trace("enter getDomain({}, {})", (Object)profileCode, (Object)objectPath);
        String profile = this.normalizeCode(profileCode);
        String path = this.normalizePath(objectPath);
        return this.getHeadOrSessionDomain(profile, path, configuration);
    }

    private HyperonDomainObject getDomainWithAllVersions(String profileCode, String objectPath, List<RegionVersion> regionVersions) {
        return this.getDomain(profileCode, objectPath, EffectiveVersionConfiguration.configurationForSnapshot(regionVersions));
    }

    @Override
    public void invalidateCache() {
        this.domainCacheManager.invalidateAllCaches();
    }

    protected HyperonDomainObject getHeadOrSessionDomain(String profile, String path, EffectiveVersionConfiguration configuration) {
        if (this.sessionProvider == null || StringUtils.isBlank((CharSequence)this.sessionProvider.getUsername())) {
            return this.domainCacheManager.getByPath(profile, path, configuration);
        }
        return this.domainCacheManager.getSessionElementByPath(profile, this.sessionProvider.getUsername(), path, configuration);
    }

    protected String normalizeCode(String profile) {
        return profile != null ? profile.trim().toUpperCase() : null;
    }

    protected String normalizePath(String domainPath) {
        Object path = domainPath;
        if (path != null) {
            if (!((String)(path = ((String)path).trim())).startsWith("/")) {
                path = "/" + (String)path;
            }
            if (((String)path).endsWith("/")) {
                path = ((String)path).substring(0, ((String)path).length() - 1);
            }
        }
        return path;
    }
}

