/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.runtime.sql;

import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.commons.lang3.StringUtils;
import pl.decerto.hyperon.runtime.sql.HyperonDialect;

public class SqlProcessor {
    private final String schema;
    private final HyperonDialect dialect;

    public SqlProcessor(HyperonDialect dialect) {
        this(dialect, null);
    }

    public SqlProcessor(HyperonDialect dialect, String schema) {
        this.schema = schema;
        this.dialect = dialect;
    }

    public int getInt(ResultSet rs, String column) throws SQLException {
        return rs.getInt(this.column(column));
    }

    public String getString(ResultSet rs, String column) throws SQLException {
        return rs.getString(this.column(column));
    }

    public boolean getBoolean(ResultSet rs, String column) throws SQLException {
        return rs.getBoolean(this.column(column));
    }

    public Date getDate(ResultSet rs, String column) throws SQLException {
        return rs.getDate(this.column(column));
    }

    public String table(String table) {
        return this.dialect.table(table);
    }

    public String column(String column) {
        return this.dialect.column(column);
    }

    public String parse(String sql) {
        String result = this.replaceTokens(sql, '$', new ColumnReplacer());
        if (this.isThereAnyHintForQuery(result = this.replaceTokens(result, '@', new TableReplacer(this.schema)))) {
            result = this.replaceTokens(result, '#', new HintReplacer());
        }
        return result;
    }

    private boolean isThereAnyHintForQuery(String result) {
        return result.indexOf(35) > -1;
    }

    String replaceTokens(String str, char c, Replacer replacer) {
        StringBuilder sb = new StringBuilder(str.length() + 16);
        int i = 0;
        while (i < str.length()) {
            int last = i;
            int begin = str.indexOf(c, i);
            if (begin < 0) {
                sb.append(str.substring(last));
                break;
            }
            sb.append(str.substring(last, begin));
            int end = this.findFirstNonIdentifier(str, begin + 1);
            String token = str.substring(begin + 1, end);
            sb.append(replacer.replace(token));
            i = end;
        }
        return sb.toString();
    }

    private int findFirstNonIdentifier(String str, int ix) {
        for (int i = ix; i < str.length(); ++i) {
            char ch = str.charAt(i);
            if (Character.isLetterOrDigit(ch) || ch == '_') continue;
            return i;
        }
        return str.length();
    }

    private class ColumnReplacer
    implements Replacer {
        private ColumnReplacer() {
        }

        @Override
        public String replace(String token) {
            return SqlProcessor.this.column(token);
        }
    }

    public static interface Replacer {
        public String replace(String var1);
    }

    private class TableReplacer
    implements Replacer {
        private String schema;

        TableReplacer(String schema) {
            this.schema = schema;
        }

        @Override
        public String replace(String token) {
            return StringUtils.isNotEmpty((CharSequence)this.schema) ? this.schema + "." + SqlProcessor.this.table(token) : SqlProcessor.this.table(token);
        }
    }

    private class HintReplacer
    implements Replacer {
        private HintReplacer() {
        }

        @Override
        public String replace(String token) {
            return SqlProcessor.this.dialect.hint(token);
        }
    }
}

