/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.core.support;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.aopalliance.aop.Advice;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.aop.interceptor.ExposeInvocationInterceptor;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.convert.support.ConfigurableConversionService;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.core.convert.support.GenericConversionService;
import org.springframework.core.env.Environment;
import org.springframework.core.env.EnvironmentCapable;
import org.springframework.core.env.StandardEnvironment;
import org.springframework.core.log.LogMessage;
import org.springframework.core.metrics.ApplicationStartup;
import org.springframework.core.metrics.StartupStep;
import org.springframework.data.expression.ValueExpressionParser;
import org.springframework.data.projection.DefaultMethodInvokingMethodInterceptor;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.projection.SpelAwareProxyProjectionFactory;
import org.springframework.data.repository.Repository;
import org.springframework.data.repository.core.EntityInformation;
import org.springframework.data.repository.core.NamedQueries;
import org.springframework.data.repository.core.RepositoryInformation;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.core.RepositoryMethodContext;
import org.springframework.data.repository.core.RepositoryMethodContextHolder;
import org.springframework.data.repository.core.support.AbstractRepositoryMetadata;
import org.springframework.data.repository.core.support.DefaultRepositoryInformation;
import org.springframework.data.repository.core.support.DefaultRepositoryMethodContext;
import org.springframework.data.repository.core.support.IncompleteRepositoryCompositionException;
import org.springframework.data.repository.core.support.MethodInvocationValidator;
import org.springframework.data.repository.core.support.PropertiesBasedNamedQueries;
import org.springframework.data.repository.core.support.QueryCreationListener;
import org.springframework.data.repository.core.support.QueryExecutorMethodInterceptor;
import org.springframework.data.repository.core.support.RepositoryComposition;
import org.springframework.data.repository.core.support.RepositoryFragment;
import org.springframework.data.repository.core.support.RepositoryInvocationMulticaster;
import org.springframework.data.repository.core.support.RepositoryMetadataAccess;
import org.springframework.data.repository.core.support.RepositoryMethodInvocationListener;
import org.springframework.data.repository.core.support.RepositoryProxyPostProcessor;
import org.springframework.data.repository.core.support.UnsupportedFragmentException;
import org.springframework.data.repository.query.ExtensionAwareQueryMethodEvaluationContextProvider;
import org.springframework.data.repository.query.QueryLookupStrategy;
import org.springframework.data.repository.query.QueryMethod;
import org.springframework.data.repository.query.QueryMethodEvaluationContextProvider;
import org.springframework.data.repository.query.QueryMethodValueEvaluationContextAccessor;
import org.springframework.data.repository.query.RepositoryQuery;
import org.springframework.data.repository.query.ValueExpressionDelegate;
import org.springframework.data.repository.util.QueryExecutionConverters;
import org.springframework.data.spel.EvaluationContextProvider;
import org.springframework.data.util.Lazy;
import org.springframework.data.util.ReflectionUtils;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.lang.Nullable;
import org.springframework.transaction.interceptor.TransactionalProxy;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;

public abstract class RepositoryFactorySupport
implements BeanClassLoaderAware,
BeanFactoryAware,
EnvironmentAware,
EnvironmentCapable {
    static final GenericConversionService CONVERSION_SERVICE = new DefaultConversionService();
    private static final ExpressionParser EXPRESSION_PARSER = new SpelExpressionParser();
    private static final ValueExpressionParser VALUE_PARSER = ValueExpressionParser.create(() -> EXPRESSION_PARSER);
    private static final Log logger = LogFactory.getLog(RepositoryFactorySupport.class);
    private final Map<RepositoryInformationCacheKey, RepositoryStub> repositoryInformationCache;
    private final List<RepositoryProxyPostProcessor> postProcessors;
    @Nullable
    private Class<?> repositoryBaseClass;
    private boolean exposeMetadata;
    @Nullable
    private QueryLookupStrategy.Key queryLookupStrategyKey;
    private final List<QueryCreationListener<?>> queryPostProcessors;
    private final List<RepositoryMethodInvocationListener> methodInvocationListeners;
    private NamedQueries namedQueries;
    private ClassLoader classLoader;
    private EvaluationContextProvider evaluationContextProvider;
    private BeanFactory beanFactory;
    private Environment environment;
    private Lazy<ProjectionFactory> projectionFactory;
    private final QueryCollectingQueryCreationListener collectingListener = new QueryCollectingQueryCreationListener();

    public RepositoryFactorySupport() {
        this.repositoryInformationCache = new HashMap<RepositoryInformationCacheKey, RepositoryStub>(8);
        this.postProcessors = new ArrayList<RepositoryProxyPostProcessor>();
        this.namedQueries = PropertiesBasedNamedQueries.EMPTY;
        this.classLoader = ClassUtils.getDefaultClassLoader();
        this.evaluationContextProvider = QueryMethodValueEvaluationContextAccessor.DEFAULT_CONTEXT_PROVIDER;
        this.queryPostProcessors = new ArrayList();
        this.queryPostProcessors.add(this.collectingListener);
        this.methodInvocationListeners = new ArrayList<RepositoryMethodInvocationListener>();
        this.projectionFactory = this.createProjectionFactory();
    }

    EvaluationContextProvider getEvaluationContextProvider() {
        return this.evaluationContextProvider;
    }

    public void setExposeMetadata(boolean exposeMetadata) {
        this.exposeMetadata = exposeMetadata;
    }

    public void setQueryLookupStrategyKey(QueryLookupStrategy.Key key) {
        this.queryLookupStrategyKey = key;
    }

    public void setNamedQueries(@Nullable NamedQueries namedQueries) {
        this.namedQueries = namedQueries == null ? PropertiesBasedNamedQueries.EMPTY : namedQueries;
    }

    public void setBeanClassLoader(@Nullable ClassLoader classLoader) {
        this.classLoader = classLoader == null ? ClassUtils.getDefaultClassLoader() : classLoader;
        this.projectionFactory = this.createProjectionFactory();
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
        this.projectionFactory = this.createProjectionFactory();
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    public Environment getEnvironment() {
        if (this.environment == null) {
            this.environment = new StandardEnvironment();
        }
        return this.environment;
    }

    @Deprecated(since="3.4")
    public void setEvaluationContextProvider(@Nullable QueryMethodEvaluationContextProvider evaluationContextProvider) {
        this.setEvaluationContextProvider(evaluationContextProvider == null ? EvaluationContextProvider.DEFAULT : evaluationContextProvider.getEvaluationContextProvider());
    }

    public void setEvaluationContextProvider(@Nullable EvaluationContextProvider evaluationContextProvider) {
        this.evaluationContextProvider = evaluationContextProvider == null ? EvaluationContextProvider.DEFAULT : evaluationContextProvider;
    }

    public void setRepositoryBaseClass(@Nullable Class<?> repositoryBaseClass) {
        this.repositoryBaseClass = repositoryBaseClass;
    }

    public void addQueryCreationListener(QueryCreationListener<?> listener) {
        Assert.notNull(listener, (String)"Listener must not be null");
        this.queryPostProcessors.add(listener);
    }

    public void addInvocationListener(RepositoryMethodInvocationListener listener) {
        Assert.notNull((Object)listener, (String)"Listener must not be null");
        this.methodInvocationListeners.add(listener);
    }

    public void addRepositoryProxyPostProcessor(RepositoryProxyPostProcessor processor) {
        Assert.notNull((Object)processor, (String)"RepositoryProxyPostProcessor must not be null");
        this.postProcessors.add(processor);
    }

    protected RepositoryComposition.RepositoryFragments getRepositoryFragments(RepositoryMetadata metadata) {
        return RepositoryComposition.RepositoryFragments.empty();
    }

    public <T> T getRepository(Class<T> repositoryInterface) {
        return this.getRepository(repositoryInterface, RepositoryComposition.RepositoryFragments.empty());
    }

    public <T> T getRepository(Class<T> repositoryInterface, Object customImplementation) {
        return this.getRepository(repositoryInterface, RepositoryComposition.RepositoryFragments.just(customImplementation));
    }

    public <T> T getRepository(Class<T> repositoryInterface, RepositoryComposition.RepositoryFragments fragments) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)LogMessage.format((String)"Initializing repository instance for %s\u2026", (Object)repositoryInterface.getName()));
        }
        Assert.notNull(repositoryInterface, (String)"Repository interface must not be null");
        Assert.notNull((Object)fragments, (String)"RepositoryFragments must not be null");
        ApplicationStartup applicationStartup = this.getStartup();
        StartupStep repositoryInit = this.onEvent(applicationStartup, "spring.data.repository.init", repositoryInterface);
        if (this.repositoryBaseClass != null) {
            repositoryInit.tag("baseClass", this.repositoryBaseClass.getName());
        }
        StartupStep repositoryMetadataStep = this.onEvent(applicationStartup, "spring.data.repository.metadata", repositoryInterface);
        RepositoryMetadata metadata = this.getRepositoryMetadata(repositoryInterface);
        repositoryMetadataStep.end();
        StartupStep repositoryCompositionStep = this.onEvent(applicationStartup, "spring.data.repository.composition", repositoryInterface);
        repositoryCompositionStep.tag("fragment.count", String.valueOf(fragments.size()));
        RepositoryStub stub = this.getRepositoryStub(metadata, fragments);
        RepositoryComposition composition = stub.composition();
        RepositoryInformation information = stub.information();
        repositoryCompositionStep.tag("fragments", () -> {
            StringBuilder fragmentsTag = new StringBuilder();
            for (RepositoryFragment<?> fragment : composition.getFragments()) {
                if (!fragmentsTag.isEmpty()) {
                    fragmentsTag.append(";");
                }
                fragmentsTag.append(fragment.getSignatureContributor().getName());
                fragmentsTag.append(fragment.getImplementation().map(it -> ":" + it.getClass().getName()).orElse(""));
            }
            return fragmentsTag.toString();
        });
        repositoryCompositionStep.end();
        StartupStep repositoryTargetStep = this.onEvent(applicationStartup, "spring.data.repository.target", repositoryInterface);
        Object target = this.getTargetRepository(information);
        repositoryTargetStep.tag("target", target.getClass().getName());
        repositoryTargetStep.end();
        RepositoryComposition compositionToUse = composition.append(RepositoryFragment.implemented(target));
        this.validate(information, compositionToUse);
        StartupStep repositoryProxyStep = this.onEvent(applicationStartup, "spring.data.repository.proxy", repositoryInterface);
        ProxyFactory result = new ProxyFactory();
        result.setTarget(target);
        result.setInterfaces(new Class[]{repositoryInterface, Repository.class, TransactionalProxy.class});
        if (MethodInvocationValidator.supports(repositoryInterface)) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)LogMessage.format((String)"Register MethodInvocationValidator for %s\u2026", (Object)repositoryInterface.getName()));
            }
            result.addAdvice((Advice)new MethodInvocationValidator());
        }
        if (this.exposeMetadata || RepositoryFactorySupport.shouldExposeMetadata(fragments)) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)LogMessage.format((String)"Register ExposeMetadataInterceptor for %s\u2026", (Object)repositoryInterface.getName()));
            }
            result.addAdvice((Advice)new ExposeMetadataInterceptor(metadata));
            result.addAdvisor(ExposeInvocationInterceptor.ADVISOR);
        }
        if (!this.postProcessors.isEmpty()) {
            StartupStep repositoryPostprocessorsStep = this.onEvent(applicationStartup, "spring.data.repository.postprocessors", repositoryInterface);
            this.postProcessors.forEach(processor -> {
                StartupStep singlePostProcessor = this.onEvent(applicationStartup, "spring.data.repository.postprocessor", repositoryInterface);
                singlePostProcessor.tag("type", processor.getClass().getName());
                processor.postProcess(result, information);
                singlePostProcessor.end();
            });
            repositoryPostprocessorsStep.end();
        }
        if (DefaultMethodInvokingMethodInterceptor.hasDefaultMethods(repositoryInterface)) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)LogMessage.format((String)"Register DefaultMethodInvokingMethodInterceptor for %s\u2026", (Object)repositoryInterface.getName()));
            }
            result.addAdvice((Advice)new DefaultMethodInvokingMethodInterceptor());
        }
        Optional<QueryLookupStrategy> queryLookupStrategy = this.getQueryLookupStrategy(this.queryLookupStrategyKey, new ValueExpressionDelegate(new QueryMethodValueEvaluationContextAccessor(this.getEnvironment(), this.evaluationContextProvider), VALUE_PARSER));
        result.addAdvice((Advice)new QueryExecutorMethodInterceptor(information, this.getProjectionFactory(), queryLookupStrategy, this.namedQueries, this.queryPostProcessors, this.methodInvocationListeners));
        result.addAdvice((Advice)new ImplementationMethodExecutionInterceptor(information, compositionToUse, this.methodInvocationListeners));
        Object repository = result.getProxy(this.classLoader);
        repositoryProxyStep.end();
        repositoryInit.end();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)LogMessage.format((String)"Finished creation of repository instance for %s.", (Object)repositoryInterface.getName()));
        }
        return (T)repository;
    }

    protected ProjectionFactory getProjectionFactory(ClassLoader classLoader, BeanFactory beanFactory) {
        SpelAwareProxyProjectionFactory factory = new SpelAwareProxyProjectionFactory(EXPRESSION_PARSER);
        factory.setBeanClassLoader(classLoader);
        factory.setBeanFactory(beanFactory);
        return factory;
    }

    protected RepositoryMetadata getRepositoryMetadata(Class<?> repositoryInterface) {
        return AbstractRepositoryMetadata.getMetadata(repositoryInterface);
    }

    protected RepositoryInformation getRepositoryInformation(RepositoryMetadata metadata, RepositoryComposition.RepositoryFragments fragments) {
        return this.getRepositoryStub(metadata, fragments).information();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RepositoryStub getRepositoryStub(RepositoryMetadata metadata, RepositoryComposition.RepositoryFragments fragments) {
        RepositoryInformationCacheKey cacheKey = new RepositoryInformationCacheKey(metadata, fragments);
        Map<RepositoryInformationCacheKey, RepositoryStub> map = this.repositoryInformationCache;
        synchronized (map) {
            return this.repositoryInformationCache.computeIfAbsent(cacheKey, key -> {
                RepositoryComposition composition = RepositoryComposition.fromMetadata(metadata);
                RepositoryComposition.RepositoryFragments repositoryAspects = this.getRepositoryFragments(metadata);
                composition = composition.append(fragments).append(repositoryAspects);
                Class<?> baseClass = this.repositoryBaseClass != null ? this.repositoryBaseClass : this.getRepositoryBaseClass(metadata);
                return new RepositoryStub(new DefaultRepositoryInformation(metadata, baseClass, composition), composition);
            });
        }
    }

    protected List<QueryMethod> getQueryMethods() {
        return this.collectingListener.getQueryMethods();
    }

    protected ProjectionFactory getProjectionFactory() {
        return this.projectionFactory.get();
    }

    public abstract <T, ID> EntityInformation<T, ID> getEntityInformation(Class<T> var1);

    protected abstract Object getTargetRepository(RepositoryInformation var1);

    protected abstract Class<?> getRepositoryBaseClass(RepositoryMetadata var1);

    @Deprecated(since="3.4")
    protected Optional<QueryLookupStrategy> getQueryLookupStrategy(@Nullable QueryLookupStrategy.Key key, QueryMethodEvaluationContextProvider evaluationContextProvider) {
        return Optional.empty();
    }

    protected Optional<QueryLookupStrategy> getQueryLookupStrategy(@Nullable QueryLookupStrategy.Key key, ValueExpressionDelegate valueExpressionDelegate) {
        return this.getQueryLookupStrategy(key, new ExtensionAwareQueryMethodEvaluationContextProvider(this.evaluationContextProvider));
    }

    private void validate(RepositoryInformation repositoryInformation, RepositoryComposition composition) {
        RepositoryValidator.validate(composition, this.getClass(), repositoryInformation);
        this.validate(repositoryInformation);
    }

    protected void validate(RepositoryMetadata repositoryMetadata) {
    }

    protected final <R> R getTargetRepositoryViaReflection(RepositoryInformation information, Object ... constructorArguments) {
        Class<?> baseClass = information.getRepositoryBaseClass();
        return this.instantiateClass(baseClass, constructorArguments);
    }

    @Deprecated
    protected final <R> R getTargetRepositoryViaReflection(Class<?> baseClass, Object ... constructorArguments) {
        return this.instantiateClass(baseClass, constructorArguments);
    }

    protected final <R> R instantiateClass(Class<?> baseClass, Object ... constructorArguments) {
        Optional<Constructor<?>> constructor = ReflectionUtils.findConstructor(baseClass, constructorArguments);
        return (R)constructor.map(it -> BeanUtils.instantiateClass((Constructor)it, (Object[])constructorArguments)).orElseThrow(() -> new IllegalStateException(String.format("No suitable constructor found on %s to match the given arguments: %s. Make sure you implement a constructor taking these", baseClass, Arrays.stream(constructorArguments).map(Object::getClass).map(ClassUtils::getQualifiedName).collect(Collectors.joining(", ")))));
    }

    private ApplicationStartup getStartup() {
        try {
            ApplicationStartup applicationStartup = this.beanFactory != null ? (ApplicationStartup)this.beanFactory.getBean(ApplicationStartup.class) : ApplicationStartup.DEFAULT;
            return applicationStartup != null ? applicationStartup : ApplicationStartup.DEFAULT;
        }
        catch (NoSuchBeanDefinitionException e) {
            return ApplicationStartup.DEFAULT;
        }
    }

    private StartupStep onEvent(ApplicationStartup applicationStartup, String name, Class<?> repositoryInterface) {
        StartupStep step = applicationStartup.start(name);
        return step.tag("repository", repositoryInterface.getName());
    }

    private Lazy<ProjectionFactory> createProjectionFactory() {
        return Lazy.of(() -> this.getProjectionFactory(this.classLoader, this.beanFactory));
    }

    private static boolean shouldExposeMetadata(RepositoryComposition.RepositoryFragments fragments) {
        for (RepositoryFragment<?> fragment : fragments) {
            if (!fragment.getImplementation().filter(RepositoryMetadataAccess.class::isInstance).isPresent()) continue;
            return true;
        }
        return false;
    }

    static {
        QueryExecutionConverters.registerConvertersIn((ConfigurableConversionService)CONVERSION_SERVICE);
        CONVERSION_SERVICE.removeConvertible(Object.class, Object.class);
    }

    private static class QueryCollectingQueryCreationListener
    implements QueryCreationListener<RepositoryQuery> {
        private final List<QueryMethod> queryMethods = new ArrayList<QueryMethod>();

        private QueryCollectingQueryCreationListener() {
        }

        @Override
        public void onCreation(RepositoryQuery query) {
            this.queryMethods.add(query.getQueryMethod());
        }

        public List<QueryMethod> getQueryMethods() {
            return this.queryMethods;
        }
    }

    record RepositoryStub(RepositoryInformation information, RepositoryComposition composition) {
    }

    private static class ExposeMetadataInterceptor
    implements MethodInterceptor,
    Serializable {
        private final RepositoryMetadata repositoryMetadata;

        public ExposeMetadataInterceptor(RepositoryMetadata repositoryMetadata) {
            this.repositoryMetadata = repositoryMetadata;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        public Object invoke(MethodInvocation invocation) throws Throwable {
            Object object;
            RepositoryMethodContext oldMetadata = null;
            try {
                oldMetadata = RepositoryMethodContextHolder.setContext(new DefaultRepositoryMethodContext(this.repositoryMetadata, invocation.getMethod()));
                object = invocation.proceed();
            }
            catch (Throwable throwable) {
                RepositoryMethodContextHolder.setContext(oldMetadata);
                throw throwable;
            }
            RepositoryMethodContextHolder.setContext(oldMetadata);
            return object;
        }
    }

    static class ImplementationMethodExecutionInterceptor
    implements MethodInterceptor {
        private final RepositoryInformation information;
        private final RepositoryComposition composition;
        private final RepositoryInvocationMulticaster invocationMulticaster;

        public ImplementationMethodExecutionInterceptor(RepositoryInformation information, RepositoryComposition composition, List<RepositoryMethodInvocationListener> methodInvocationListeners) {
            this.information = information;
            this.composition = composition;
            this.invocationMulticaster = methodInvocationListeners.isEmpty() ? RepositoryInvocationMulticaster.NoOpRepositoryInvocationMulticaster.INSTANCE : new RepositoryInvocationMulticaster.DefaultRepositoryInvocationMulticaster(methodInvocationListeners);
        }

        @Nullable
        public Object invoke(MethodInvocation invocation) throws Throwable {
            Method method = invocation.getMethod();
            Object[] arguments = invocation.getArguments();
            try {
                return this.composition.invoke(this.invocationMulticaster, method, arguments);
            }
            catch (Exception e) {
                org.springframework.data.repository.util.ClassUtils.unwrapReflectionException(e);
                throw new IllegalStateException("Should not occur");
            }
        }
    }

    private static final class RepositoryInformationCacheKey {
        private final String repositoryInterfaceName;
        private final long fragmentsHash;

        public RepositoryInformationCacheKey(RepositoryMetadata metadata, RepositoryComposition.RepositoryFragments fragments) {
            this.repositoryInterfaceName = metadata.getRepositoryInterface().getName();
            this.fragmentsHash = fragments.getFragments().hashCode();
        }

        public String getRepositoryInterfaceName() {
            return this.repositoryInterfaceName;
        }

        public long getFragmentsHash() {
            return this.fragmentsHash;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof RepositoryInformationCacheKey)) {
                return false;
            }
            RepositoryInformationCacheKey that = (RepositoryInformationCacheKey)o;
            if (this.fragmentsHash != that.fragmentsHash) {
                return false;
            }
            return ObjectUtils.nullSafeEquals((Object)this.repositoryInterfaceName, (Object)that.repositoryInterfaceName);
        }

        public int hashCode() {
            int result = ObjectUtils.nullSafeHashCode((Object)this.repositoryInterfaceName);
            result = 31 * result + Long.hashCode(this.fragmentsHash);
            return result;
        }

        public String toString() {
            return "RepositoryFactorySupport.RepositoryInformationCacheKey(repositoryInterfaceName=" + this.getRepositoryInterfaceName() + ", fragmentsHash=" + this.getFragmentsHash() + ")";
        }
    }

    static class RepositoryValidator {
        static Map<Class<?>, String> WELL_KNOWN_EXECUTORS = new HashMap(4, 1.0f);

        RepositoryValidator() {
        }

        public static void validate(RepositoryComposition composition, Class<?> source, RepositoryInformation repositoryInformation) {
            Class<?> repositoryInterface = repositoryInformation.getRepositoryInterface();
            if (repositoryInformation.hasCustomMethod()) {
                if (composition.isEmpty()) {
                    throw new IncompleteRepositoryCompositionException(String.format("You have custom methods in %s but have not provided a custom implementation", ClassUtils.getQualifiedName(repositoryInterface)), repositoryInterface);
                }
                composition.validateImplementation();
            }
            for (Map.Entry<Class<?>, String> entry : WELL_KNOWN_EXECUTORS.entrySet()) {
                Class<?> executorInterface = entry.getKey();
                if (!executorInterface.isAssignableFrom(repositoryInterface) || RepositoryValidator.containsFragmentImplementation(composition, executorInterface)) continue;
                throw new UnsupportedFragmentException(String.format("Repository %s implements %s but %s does not support %s", ClassUtils.getQualifiedName(repositoryInterface), ClassUtils.getQualifiedName(executorInterface), ClassUtils.getShortName(source), entry.getValue()), repositoryInterface, executorInterface);
            }
        }

        private static boolean containsFragmentImplementation(RepositoryComposition composition, Class<?> executorInterface) {
            for (RepositoryFragment<?> fragment : composition.getFragments()) {
                if (!fragment.getImplementation().filter(executorInterface::isInstance).isPresent()) continue;
                return true;
            }
            return false;
        }

        static {
            org.springframework.data.repository.util.ClassUtils.ifPresent("org.springframework.data.querydsl.QuerydslPredicateExecutor", RepositoryValidator.class.getClassLoader(), it -> WELL_KNOWN_EXECUTORS.put((Class<?>)it, "Querydsl"));
            org.springframework.data.repository.util.ClassUtils.ifPresent("org.springframework.data.querydsl.ReactiveQuerydslPredicateExecutor", RepositoryValidator.class.getClassLoader(), it -> WELL_KNOWN_EXECUTORS.put((Class<?>)it, "Reactive Querydsl"));
            org.springframework.data.repository.util.ClassUtils.ifPresent("org.springframework.data.repository.query.QueryByExampleExecutor", RepositoryValidator.class.getClassLoader(), it -> WELL_KNOWN_EXECUTORS.put((Class<?>)it, "Query by Example"));
            org.springframework.data.repository.util.ClassUtils.ifPresent("org.springframework.data.repository.query.ReactiveQueryByExampleExecutor", RepositoryValidator.class.getClassLoader(), it -> WELL_KNOWN_EXECUTORS.put((Class<?>)it, "Reactive Query by Example"));
        }
    }
}

