/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.autoconfig.instrument.cassandra;

import com.datastax.oss.driver.api.core.CqlSession;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.cassandra.CassandraAutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.cloud.sleuth.autoconfig.brave.BraveAutoConfiguration;
import org.springframework.cloud.sleuth.autoconfig.instrument.cassandra.TraceCqlSessionBeanPostProcessor;
import org.springframework.cloud.sleuth.instrument.cassandra.TraceCqlSessionBuilderCustomizer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@ConditionalOnBean(value={Tracer.class})
@ConditionalOnProperty(value={"spring.sleuth.cassandra.enabled"}, matchIfMissing=true)
@AutoConfigureAfter(value={BraveAutoConfiguration.class})
@AutoConfigureBefore(value={CassandraAutoConfiguration.class})
@ConditionalOnClass(value={CqlSession.class})
public class TraceCassandraAutoConfiguration {
    @Bean
    static TraceCqlSessionBeanPostProcessor traceCqlSessionBeanPostProcessor(BeanFactory beanFactory) {
        return new TraceCqlSessionBeanPostProcessor(beanFactory);
    }

    @Bean
    TraceCqlSessionBuilderCustomizer traceCqlSessionBuilderCustomizer() {
        return new TraceCqlSessionBuilderCustomizer();
    }
}

