/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.rest.configuration;

import io.higson.runtime.core.HigsonEngine;
import io.higson.runtime.core.HigsonEngineFactory;
import io.higson.runtime.core.domain.DomainCache;
import javax.sql.DataSource;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import pl.decerto.hyperon.common.external.ExternalDataSourceProvider;
import pl.decerto.hyperon.rest.configuration.HyperonEngineProperties;

@Configuration
@EnableConfigurationProperties(value={HyperonEngineProperties.class})
public class HyperonEngineConfiguration {
    private final ExternalDataSourceProvider externalDataSourceProvider;

    @Bean(destroyMethod="destroy")
    public HigsonEngineFactory higsonEngineFactory(@Qualifier(value="dataSource") DataSource dataSource, HyperonEngineProperties properties) {
        this.externalDataSourceProvider.configure(dataSource);
        HigsonEngineFactory factory = new HigsonEngineFactory(dataSource);
        factory.setDeveloperMode(properties.getRuntime().isDevModeEnabled());
        factory.setUsername(properties.getRuntime().getUsername());
        factory.setMaxConcurrentLoads(properties.getRuntime().getMaxConcurrentLoads());
        factory.setWatcherPauseSeconds(properties.getRuntime().getWatcher().getPauseSeconds());
        factory.setWatcherForceSyncSeconds(properties.getRuntime().getWatcher().getForceSyncSeconds());
        factory.setValidateFunctionArgumentsDataTypes(properties.getRuntime().getFunction().isValidateArguments());
        factory.setThrowOnNormalizeInputValueException(properties.getRuntime().getNormalization().isThrowOnException());
        factory.setGroovySecured(properties.getRuntime().getGroovy().isSecured());
        factory.addExternalDataSources(this.externalDataSourceProvider.getDataSources());
        return factory;
    }

    @Bean
    public HigsonEngine higsonEngine(HigsonEngineFactory engineFactory) {
        return engineFactory.create();
    }

    @Bean
    @DependsOn(value={"higsonEngine"})
    public DomainCache domainCache(HigsonEngineFactory engineFactory) {
        return engineFactory.getDomainCache();
    }

    public HyperonEngineConfiguration(ExternalDataSourceProvider externalDataSourceProvider) {
        this.externalDataSourceProvider = externalDataSourceProvider;
    }
}

