/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.rest.configuration;

import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.EnableScheduling;
import pl.decerto.hyperon.common.security.cache.UserCacheWatcher;
import pl.decerto.hyperon.rest.cache.user.SystemUserCacheWatcher;

@Configuration
@EnableScheduling
@ConditionalOnProperty(prefix="higson.security.user", name={"cache"}, havingValue="true")
public class HyperonUserCacheWatchersConfiguration {
    private final UserCacheWatcher userCacheWatcher;
    private final SystemUserCacheWatcher systemUserCacheWatcher;

    @PostConstruct
    public void start() {
        this.userCacheWatcher.start();
        this.systemUserCacheWatcher.start();
    }

    @PreDestroy
    public void stop() {
        this.userCacheWatcher.stop();
        this.systemUserCacheWatcher.stop();
    }

    public HyperonUserCacheWatchersConfiguration(UserCacheWatcher userCacheWatcher, SystemUserCacheWatcher systemUserCacheWatcher) {
        this.userCacheWatcher = userCacheWatcher;
        this.systemUserCacheWatcher = systemUserCacheWatcher;
    }
}

