/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.rest.execution;

import io.higson.runtime.core.HigsonContext;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.stereotype.Component;
import pl.decerto.hyperon.rest.execution.api.dto.ContextProperty;
import pl.decerto.hyperon.rest.execution.api.dto.ExecutionData;

@Component
class ContextBuilder {
    ContextBuilder() {
    }

    HigsonContext create(ExecutionData executionData) {
        return this.create(this.getProperties(executionData));
    }

    HigsonContext create(List<ContextProperty> properties) {
        HigsonContext ctx = new HigsonContext(new Object[0]);
        for (ContextProperty property : properties) {
            if (property.getValue() != null) {
                ctx.set(property.getKey(), (Object)property.getValue());
                continue;
            }
            if (property.getValues() != null) {
                ctx.set(property.getKey(), property.getValues());
                continue;
            }
            if (property.getComplexValue() != null) {
                ctx.set(property.getKey(), (Object)this.create(property.getComplexValue()));
                continue;
            }
            if (property.getComplexValues() == null) continue;
            ctx.set(property.getKey(), this.createCollection(property.getComplexValues()));
        }
        return ctx;
    }

    private List<HigsonContext> createCollection(List<List<ContextProperty>> properties) {
        return properties.stream().map(this::create).collect(Collectors.toList());
    }

    private List<ContextProperty> getProperties(ExecutionData executionData) {
        return executionData.getCtx() == null ? Collections.emptyList() : executionData.getCtx().getProperties();
    }
}

