/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.rest.execution.api.dto;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.annotation.Nullable;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.util.List;
import javax.validation.Valid;
import pl.decerto.hyperon.rest.execution.api.dto.EffectiveVersionConfigurationDto;
import pl.decerto.hyperon.rest.execution.api.dto.ExecutionContext;
import pl.decerto.hyperon.rest.execution.api.dto.ExecutionElementIdentifier;

@JsonIgnoreProperties(ignoreUnknown=true)
public class ExecutionData {
    private static final String ARGUMENT_EXAMPLE = "\t[true, 3.1, \"argument\"]\n";
    @Nullable
    @Valid
    private ExecutionContext ctx;
    @Nullable
    @Valid
    private EffectiveVersionConfigurationDto effectiveVersionConfiguration;
    @NotNull
    @Size(min=1)
    @Valid
    private @NotNull @Size(min=1) @Valid List<ExecutionElementIdentifier> elements;
    @Nullable
    @Schema(description="Collection of arguments for function (if requires them). Only types supported by Higson.", example="\t[true, 3.1, \"argument\"]\n")
    private List<Object> arguments;

    @Nullable
    public ExecutionContext getCtx() {
        return this.ctx;
    }

    @Nullable
    public EffectiveVersionConfigurationDto getEffectiveVersionConfiguration() {
        return this.effectiveVersionConfiguration;
    }

    public List<ExecutionElementIdentifier> getElements() {
        return this.elements;
    }

    @Nullable
    public List<Object> getArguments() {
        return this.arguments;
    }

    public void setCtx(@Nullable ExecutionContext ctx) {
        this.ctx = ctx;
    }

    public void setEffectiveVersionConfiguration(@Nullable EffectiveVersionConfigurationDto effectiveVersionConfiguration) {
        this.effectiveVersionConfiguration = effectiveVersionConfiguration;
    }

    public void setElements(List<ExecutionElementIdentifier> elements) {
        this.elements = elements;
    }

    public void setArguments(@Nullable List<Object> arguments) {
        this.arguments = arguments;
    }

    public String toString() {
        return "ExecutionData(ctx=" + this.getCtx() + ", effectiveVersionConfiguration=" + this.getEffectiveVersionConfiguration() + ", elements=" + this.getElements() + ", arguments=" + this.getArguments() + ")";
    }
}

