/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.rest.execution.api.dto;

import io.higson.runtime.model.ElementType;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import java.util.List;

public class ExecutionElementIdentifier {
    @NotNull
    @Schema(example="demo.motor.coverage.position", description="parameter/function code or domain path to specific object")
    private String code;
    @NotNull
    @Schema(example="PARAMETER")
    private ElementType type;
    private String attributeCode;
    private String profileCode;
    private List<Object> functionArguments;

    public ExecutionElementIdentifier() {
    }

    public ExecutionElementIdentifier(String code, ElementType type, String attributeCode, String profileCode) {
        this.code = code;
        this.type = type;
        this.attributeCode = attributeCode;
        this.profileCode = profileCode;
    }

    public ExecutionElementIdentifier(String code, List<Object> functionArguments) {
        this.code = code;
        this.type = ElementType.FUNCTION;
        this.functionArguments = functionArguments;
    }

    public String getCode() {
        return this.code;
    }

    public ElementType getType() {
        return this.type;
    }

    public String getAttributeCode() {
        return this.attributeCode;
    }

    public String getProfileCode() {
        return this.profileCode;
    }

    public List<Object> getFunctionArguments() {
        return this.functionArguments;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public void setType(ElementType type) {
        this.type = type;
    }

    public void setAttributeCode(String attributeCode) {
        this.attributeCode = attributeCode;
    }

    public void setProfileCode(String profileCode) {
        this.profileCode = profileCode;
    }

    public void setFunctionArguments(List<Object> functionArguments) {
        this.functionArguments = functionArguments;
    }

    public String toString() {
        return "ExecutionElementIdentifier(code=" + this.getCode() + ", type=" + this.getType() + ", attributeCode=" + this.getAttributeCode() + ", profileCode=" + this.getProfileCode() + ", functionArguments=" + this.getFunctionArguments() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExecutionElementIdentifier)) {
            return false;
        }
        ExecutionElementIdentifier other = (ExecutionElementIdentifier)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$code = this.getCode();
        String other$code = other.getCode();
        if (this$code == null ? other$code != null : !this$code.equals(other$code)) {
            return false;
        }
        ElementType this$type = this.getType();
        ElementType other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$attributeCode = this.getAttributeCode();
        String other$attributeCode = other.getAttributeCode();
        if (this$attributeCode == null ? other$attributeCode != null : !this$attributeCode.equals(other$attributeCode)) {
            return false;
        }
        String this$profileCode = this.getProfileCode();
        String other$profileCode = other.getProfileCode();
        if (this$profileCode == null ? other$profileCode != null : !this$profileCode.equals(other$profileCode)) {
            return false;
        }
        List<Object> this$functionArguments = this.getFunctionArguments();
        List<Object> other$functionArguments = other.getFunctionArguments();
        return !(this$functionArguments == null ? other$functionArguments != null : !((Object)this$functionArguments).equals(other$functionArguments));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ExecutionElementIdentifier;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $code = this.getCode();
        result = result * 59 + ($code == null ? 43 : $code.hashCode());
        ElementType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $attributeCode = this.getAttributeCode();
        result = result * 59 + ($attributeCode == null ? 43 : $attributeCode.hashCode());
        String $profileCode = this.getProfileCode();
        result = result * 59 + ($profileCode == null ? 43 : $profileCode.hashCode());
        List<Object> $functionArguments = this.getFunctionArguments();
        result = result * 59 + ($functionArguments == null ? 43 : ((Object)$functionArguments).hashCode());
        return result;
    }
}

