/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.ssl;

import java.security.KeyStore;
import org.springframework.core.style.ToStringCreator;

public interface SslStoreBundle {
    public static final SslStoreBundle NONE = SslStoreBundle.of(null, null, null);

    public KeyStore getKeyStore();

    public String getKeyStorePassword();

    public KeyStore getTrustStore();

    public static SslStoreBundle of(final KeyStore keyStore, final String keyStorePassword, final KeyStore trustStore) {
        return new SslStoreBundle(){

            @Override
            public KeyStore getKeyStore() {
                return keyStore;
            }

            @Override
            public KeyStore getTrustStore() {
                return trustStore;
            }

            @Override
            public String getKeyStorePassword() {
                return keyStorePassword;
            }

            public String toString() {
                ToStringCreator creator = new ToStringCreator((Object)this);
                creator.append("keyStore.type", (Object)(keyStore != null ? keyStore.getType() : "none"));
                creator.append("keyStorePassword", (Object)(keyStorePassword != null ? "******" : null));
                creator.append("trustStore.type", (Object)(trustStore != null ? trustStore.getType() : "none"));
                return creator.toString();
            }
        };
    }
}

