/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.changes;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import liquibase.change.custom.CustomTaskChange;
import liquibase.database.Database;
import liquibase.database.jvm.JdbcConnection;
import liquibase.exception.CustomChangeException;
import liquibase.exception.DatabaseException;
import liquibase.exception.SetupException;
import liquibase.exception.ValidationErrors;
import liquibase.resource.ResourceAccessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GroupOrderInit
implements CustomTaskChange {
    private static final Logger log = LoggerFactory.getLogger(GroupOrderInit.class);

    public String getConfirmationMessage() {
        return "groupOrder has been updated";
    }

    public void setUp() throws SetupException {
    }

    public void setFileOpener(ResourceAccessor resourceAccessor) {
    }

    public ValidationErrors validate(Database database) {
        return new ValidationErrors();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Database database) throws CustomChangeException {
        JdbcConnection databaseConnection = (JdbcConnection)database.getConnection();
        Statement statement = null;
        ResultSet resultSet = null;
        PreparedStatement updateStatement = null;
        PreparedStatement updateNullGroupStmnt = null;
        try {
            statement = databaseConnection.createStatement();
            statement.execute("select distinct type_id, groupname from domaintypeattribute order by type_id, groupname");
            resultSet = statement.getResultSet();
            int currentType = -1;
            int currentIndex = 1;
            updateStatement = databaseConnection.prepareStatement("update domaintypeattribute set grouporder=? where type_id=? and groupname=?");
            updateNullGroupStmnt = databaseConnection.prepareStatement("update domaintypeattribute set grouporder=? where type_id=? and groupname is null");
            while (resultSet.next()) {
                int typeId = resultSet.getInt("type_id");
                String currentGroup = resultSet.getString("groupname");
                if (typeId != currentType) {
                    currentType = typeId;
                    currentIndex = 1;
                }
                if (currentGroup != null) {
                    updateStatement.setInt(1, currentIndex);
                    updateStatement.setInt(2, currentType);
                    updateStatement.setString(3, currentGroup);
                    updateStatement.execute();
                } else {
                    updateNullGroupStmnt.setInt(1, currentIndex);
                    updateNullGroupStmnt.setInt(2, currentType);
                    updateNullGroupStmnt.execute();
                }
                ++currentIndex;
            }
            databaseConnection.commit();
            this.closeQuietly(updateStatement);
            this.closeQuietly(updateNullGroupStmnt);
            this.closeQuietly(resultSet);
            this.closeQuietly(statement);
        }
        catch (SQLException | DatabaseException e) {
            log.error("", e);
        }
        finally {
            this.closeQuietly(updateStatement);
            this.closeQuietly(updateNullGroupStmnt);
            this.closeQuietly(resultSet);
            this.closeQuietly(statement);
        }
    }

    private void closeQuietly(ResultSet rs) {
        try {
            if (rs != null) {
                rs.close();
            }
        }
        catch (SQLException e) {
            log.error("", (Throwable)e);
        }
    }

    private void closeQuietly(Statement stmt) {
        try {
            if (stmt != null) {
                stmt.close();
            }
        }
        catch (SQLException e) {
            log.error("", (Throwable)e);
        }
    }
}

