/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.common.security;

import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import pl.decerto.hyperon.common.security.AccessByProfileService;
import pl.decerto.hyperon.common.security.cache.UserCacheEntry;
import pl.decerto.hyperon.common.security.cache.UsersCacheManager;
import pl.decerto.hyperon.common.security.domain.SystemRights;
import pl.decerto.hyperon.common.utils.LoginHelper;

@Service
public class AccessByProfileServiceImpl
implements AccessByProfileService {
    public static final String READ_ACCESS_PREFIX = "PROD_R_";
    public static final String WRITE_ACCESS_PREFIX = "PROD_W_";
    private final UsersCacheManager userCache;

    @Autowired
    public AccessByProfileServiceImpl(UsersCacheManager userCache) {
        this.userCache = userCache;
    }

    @Override
    public boolean isNoReadRight(String profile) {
        return !this.rightControl(profile, true);
    }

    @Override
    public boolean isWriteRight(String profile) {
        return this.rightControl(profile, false);
    }

    private boolean rightControl(String profile, boolean read) {
        Set<String> myAccessRight = this.findAllControllingAccessByProfile(!read);
        if (myAccessRight.contains(read ? SystemRights.PROD_R_ALL.name() : SystemRights.PROD_W_ALL.name())) {
            return true;
        }
        if (StringUtils.isNotBlank((CharSequence)profile)) {
            String categoryRight = (read ? READ_ACCESS_PREFIX : WRITE_ACCESS_PREFIX) + profile;
            return myAccessRight.contains(categoryRight);
        }
        return true;
    }

    private Set<String> findAllControllingAccessByProfile(boolean write) {
        UserCacheEntry cachedData = this.userCache.getUserCacheEntry(LoginHelper.getCurrentUserName());
        if (cachedData == null) {
            return new HashSet<String>();
        }
        if (write) {
            return cachedData.getDomainWriteRights();
        }
        return cachedData.getDomainReadRights();
    }
}

