/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.common.security.activedirectory;

import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.stereotype.Component;
import pl.decerto.hyperon.common.security.UserDetailsAdditionalHolder;
import pl.decerto.hyperon.common.security.UserManagementService;
import pl.decerto.hyperon.common.security.activedirectory.exception.EmptyFirstOrLastNameException;
import pl.decerto.hyperon.common.security.activedirectory.exception.InternalUserException;
import pl.decerto.hyperon.common.security.activedirectory.exception.NoRoleAssignedException;
import pl.decerto.hyperon.common.security.activedirectory.exception.NotUniqueEmailException;
import pl.decerto.hyperon.common.security.activedirectory.exception.NotUniqueLoginException;
import pl.decerto.hyperon.common.security.domain.UserStatus;
import pl.decerto.hyperon.common.security.dto.SystemUser;
import pl.decerto.hyperon.common.utils.Messages;

@Component
public class ActiveDirectoryUserDetailsValidator {
    private final UserManagementService userService;

    public ActiveDirectoryUserDetailsValidator(UserManagementService userService) {
        this.userService = userService;
    }

    boolean validateUser(SystemUser systemUser) {
        if (this.isLoginUsed(systemUser)) {
            throw new NotUniqueLoginException(Messages.message("authentication.accessDenied.not.unique.login"));
        }
        if (this.isEmailUsed(systemUser)) {
            throw new NotUniqueEmailException(Messages.message("authentication.accessDenied.not.unique.email"));
        }
        if (this.isFirstOrLastNameBlank(systemUser)) {
            throw new EmptyFirstOrLastNameException(Messages.message("authentication.accessDenied.empty.first.or.last.name"));
        }
        return true;
    }

    private boolean isLoginUsed(SystemUser systemUser) {
        SystemUser existingUser = this.userService.getUserByLogin(systemUser.getLogin());
        return this.equalUsersId(systemUser, existingUser);
    }

    private boolean isEmailUsed(SystemUser systemUser) {
        if (StringUtils.isNotBlank((CharSequence)systemUser.getEmail())) {
            SystemUser existingUser = this.userService.getUserByEmail(systemUser.getEmail());
            return this.equalUsersId(systemUser, existingUser);
        }
        return false;
    }

    private boolean equalUsersId(SystemUser systemUser, SystemUser existingUser) {
        return existingUser != null && existingUser.getId() != systemUser.getId();
    }

    private boolean isFirstOrLastNameBlank(SystemUser systemUser) {
        return StringUtils.isBlank((CharSequence)systemUser.getFirstName()) || StringUtils.isBlank((CharSequence)systemUser.getLastName());
    }

    boolean isValidToUpdate(SystemUser user, SystemUser tempUser) {
        return this.isExternalUser(user) && tempUser.getStatus() == UserStatus.EXTERNAL && !user.equals(tempUser) && CollectionUtils.isNotEmpty(tempUser.getRoles());
    }

    private boolean isExternalUser(SystemUser user) {
        if (user.getStatus() != UserStatus.EXTERNAL) {
            throw new InternalUserException(Messages.message("authentication.accessDenied.user.exists.as.internal.user"));
        }
        return true;
    }

    boolean validateUserRoles(String[] roles) {
        if (Objects.isNull(roles)) {
            throw new NoRoleAssignedException(Messages.message("authentication.accessDenied.no.role"));
        }
        return true;
    }

    void validateUserDetailsHolder(UserDetailsAdditionalHolder userDetailsAdditionalHolder) {
        if (!(userDetailsAdditionalHolder.isAccountNonExpired() && userDetailsAdditionalHolder.isAccountNonLocked() && userDetailsAdditionalHolder.isCredentialsNonExpired() && userDetailsAdditionalHolder.isEnabled())) {
            throw new BadCredentialsException("authentication.accessDenied.user.is.inactive");
        }
    }
}

