/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.common.security.oauth2;

import jakarta.servlet.http.HttpSession;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.oauth2.client.oidc.userinfo.OidcUserRequest;
import org.springframework.security.oauth2.client.oidc.userinfo.OidcUserService;
import org.springframework.security.oauth2.client.userinfo.OAuth2UserService;
import org.springframework.security.oauth2.core.oidc.OidcIdToken;
import org.springframework.security.oauth2.core.oidc.user.OidcUser;
import org.springframework.security.oauth2.core.oidc.user.OidcUserAuthority;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import pl.decerto.hyperon.common.security.MppUserDetails;
import pl.decerto.hyperon.common.security.cache.UsersCacheManager;
import pl.decerto.hyperon.common.security.dto.SystemUser;
import pl.decerto.hyperon.common.security.oauth2.HyperonOidcUserDetails;
import pl.decerto.hyperon.common.security.oauth2.OAuth2PropertyCondition;
import pl.decerto.hyperon.common.security.oauth2.OAuth2SystemUserCreator;

@Configuration
@OAuth2PropertyCondition
public class OAuth2UserServiceConfiguration {
    private static final String NAME_ATTRIBUTE_KEY = "name";
    private static final String HYPERON_OIDC_USER = "hyperonOidcUser";
    private final OAuth2SystemUserCreator oAuth2SystemUserCreator;
    private final UsersCacheManager userCache;

    public OAuth2UserServiceConfiguration(OAuth2SystemUserCreator oAuth2SystemUserCreator, UsersCacheManager userCache) {
        this.oAuth2SystemUserCreator = oAuth2SystemUserCreator;
        this.userCache = userCache;
    }

    @Bean
    public OAuth2UserService<OidcUserRequest, OidcUser> oidcUserService() {
        OidcUserService delegate = new OidcUserService();
        return userRequest -> {
            OidcUser oidcUser = delegate.loadUser(userRequest);
            Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
            ServletRequestAttributes attr = (ServletRequestAttributes)RequestContextHolder.currentRequestAttributes();
            HttpSession session = attr.getRequest().getSession(true);
            if (authentication != null) {
                return (HyperonOidcUserDetails)((Object)((Object)session.getAttribute(HYPERON_OIDC_USER)));
            }
            Set<SimpleGrantedAuthority> authorities = OAuth2UserServiceConfiguration.getAuthorities(oidcUser);
            OidcIdToken idToken = oidcUser.getIdToken();
            HyperonOidcUserDetails hyperonOidcUserDetails = new HyperonOidcUserDetails(authorities, idToken, NAME_ATTRIBUTE_KEY);
            SystemUser systemUser = this.createOrUpdateSystemUser(hyperonOidcUserDetails);
            MppUserDetails hyperonUserDetails = MppUserDetails.createMppUserDetails(systemUser, this.userCache.getUserCacheEntry(systemUser.getLogin()));
            hyperonOidcUserDetails.setHyperonUserDetails(hyperonUserDetails);
            session.setAttribute(HYPERON_OIDC_USER, (Object)hyperonOidcUserDetails);
            return hyperonOidcUserDetails;
        };
    }

    private static Set<SimpleGrantedAuthority> getAuthorities(OidcUser oidcUser) {
        return oidcUser.getAuthorities().stream().filter(it -> it instanceof OidcUserAuthority).map(GrantedAuthority::getAuthority).filter(authority -> authority.toLowerCase().contains("role")).map(SimpleGrantedAuthority::new).collect(Collectors.toUnmodifiableSet());
    }

    private SystemUser createOrUpdateSystemUser(HyperonOidcUserDetails hyperonOidcUserDetails) {
        String login = (String)hyperonOidcUserDetails.getAttribute(NAME_ATTRIBUTE_KEY);
        return this.oAuth2SystemUserCreator.createOrUpdate(login, hyperonOidcUserDetails);
    }
}

