/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.common.utils.resources;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import pl.decerto.hyperon.common.utils.resources.AbstractTypedResourceBundle;

public class TypedSingleResourceBundle<T>
extends AbstractTypedResourceBundle<T> {
    private String key;
    private T value;

    public TypedSingleResourceBundle() {
    }

    public TypedSingleResourceBundle(String key, T value) {
        if (value != null) {
            if (key == null) {
                throw new IllegalArgumentException("Attempt to create " + TypedSingleResourceBundle.class.getSimpleName() + " with null key and non-null value");
            }
            this.key = key;
            this.value = value;
        }
    }

    @Override
    protected T handleGetObject(String key) {
        if (this.hasValue() && this.key.equals(key)) {
            return this.value;
        }
        return null;
    }

    @Override
    protected Set<String> handleKeySet() {
        if (this.isEmpty()) {
            return Collections.emptySet();
        }
        return Collections.singleton(this.key);
    }

    public T getValue() {
        return this.value;
    }

    public boolean hasValue() {
        return this.key != null;
    }

    public boolean isEmpty() {
        return this.key == null;
    }

    public static abstract class TypedSingleControl<T>
    extends AbstractTypedResourceBundle.AbstractTypedControl<T, TypedSingleResourceBundle<T>> {
        public TypedSingleControl(List<String> formats) {
            super(formats);
        }

        @Override
        protected final TypedSingleResourceBundle<T> readBundle(BufferedInputStream inputStream, String format) throws IOException, IllegalAccessException, InstantiationException {
            Map.Entry<String, T> entry = this.readSingleEntry(inputStream);
            return new TypedSingleResourceBundle<T>(entry.getKey(), entry.getValue());
        }

        protected abstract Map.Entry<String, T> readSingleEntry(BufferedInputStream var1) throws IOException, IllegalAccessException, InstantiationException;
    }
}

