/*
 * Decompiled with CFR 0.152.
 */
package ai.onnxruntime;

import ai.onnxruntime.OnnxRuntime;
import ai.onnxruntime.OrtAllocator;
import ai.onnxruntime.OrtException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Objects;

public final class OrtLoraAdapter
implements AutoCloseable {
    private final long nativeHandle;
    private boolean closed = false;

    private OrtLoraAdapter(long nativeHandle) {
        this.nativeHandle = nativeHandle;
    }

    public static OrtLoraAdapter create(byte[] loraArray) throws OrtException {
        return OrtLoraAdapter.create(loraArray, null);
    }

    static OrtLoraAdapter create(byte[] loraArray, OrtAllocator allocator) throws OrtException {
        Objects.requireNonNull(loraArray, "LoRA array must not be null");
        long allocatorHandle = allocator == null ? 0L : allocator.handle;
        return new OrtLoraAdapter(OrtLoraAdapter.createLoraAdapterFromArray(OnnxRuntime.ortApiHandle, loraArray, allocatorHandle));
    }

    public static OrtLoraAdapter create(ByteBuffer loraBuffer) throws OrtException {
        return OrtLoraAdapter.create(loraBuffer, null);
    }

    static OrtLoraAdapter create(ByteBuffer loraBuffer, OrtAllocator allocator) throws OrtException {
        Objects.requireNonNull(loraBuffer, "LoRA buffer must not be null");
        if (loraBuffer.remaining() == 0) {
            throw new OrtException("Invalid LoRA buffer, no elements remaining.");
        }
        if (!loraBuffer.isDirect()) {
            throw new OrtException("ByteBuffer is not direct.");
        }
        long allocatorHandle = allocator == null ? 0L : allocator.handle;
        return new OrtLoraAdapter(OrtLoraAdapter.createLoraAdapterFromBuffer(OnnxRuntime.ortApiHandle, loraBuffer, loraBuffer.position(), loraBuffer.remaining(), allocatorHandle));
    }

    public static OrtLoraAdapter create(String adapterPath) throws OrtException {
        return OrtLoraAdapter.create(adapterPath, null);
    }

    static OrtLoraAdapter create(String adapterPath, OrtAllocator allocator) throws OrtException {
        long allocatorHandle = allocator == null ? 0L : allocator.handle;
        return new OrtLoraAdapter(OrtLoraAdapter.createLoraAdapter(OnnxRuntime.ortApiHandle, adapterPath, allocatorHandle));
    }

    long getNativeHandle() {
        return this.nativeHandle;
    }

    void checkClosed() {
        if (this.closed) {
            throw new IllegalStateException("Trying to use a closed OrtLoraAdapter");
        }
    }

    @Override
    public void close() {
        if (this.closed) {
            throw new IllegalStateException("Trying to close an already closed OrtLoraAdapter");
        }
        OrtLoraAdapter.close(OnnxRuntime.ortApiHandle, this.nativeHandle);
        this.closed = true;
    }

    private static native long createLoraAdapter(long var0, String var2, long var3) throws OrtException;

    private static native long createLoraAdapterFromArray(long var0, byte[] var2, long var3) throws OrtException;

    private static native long createLoraAdapterFromBuffer(long var0, ByteBuffer var2, int var3, int var4, long var5) throws OrtException;

    private static native void close(long var0, long var2);

    static {
        try {
            OnnxRuntime.init();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to load onnx-runtime library", e);
        }
    }
}

