/*
 * Decompiled with CFR 0.152.
 */
package ai.onnxruntime.providers;

import ai.onnxruntime.OrtException;
import ai.onnxruntime.OrtProviderOptions;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

abstract class StringConfigProviderOptions
extends OrtProviderOptions {
    protected final Map<String, String> options = new LinkedHashMap<String, String>();

    protected StringConfigProviderOptions(long nativeHandle) {
        super(nativeHandle);
    }

    public void add(String key, String value) throws OrtException {
        this.checkClosed();
        Objects.requireNonNull(key, "Key must not be null");
        Objects.requireNonNull(value, "Value must not be null");
        this.options.put(key, value);
    }

    public void parseOptionsString(String serializedForm) throws OrtException {
        String[] options;
        for (String o : options = serializedForm.split(";")) {
            if (!o.contains("=")) continue;
            String[] curOption = o.split("=");
            if (curOption.length == 2 && !curOption[0].isEmpty() && !curOption[1].isEmpty()) {
                this.add(curOption[0], curOption[1]);
                continue;
            }
            throw new IllegalArgumentException("Failed to parse option from string '" + o + "'");
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.getOptionsString() + ")";
    }

    public String getOptionsString() {
        return this.options.entrySet().stream().map(e -> (String)e.getKey() + "=" + (String)e.getValue()).collect(Collectors.joining(";", "", ";"));
    }

    @Override
    protected void applyToNative() throws OrtException {
        if (!this.options.isEmpty()) {
            String[] keys = new String[this.options.size()];
            String[] values = new String[this.options.size()];
            int i = 0;
            for (Map.Entry<String, String> e : this.options.entrySet()) {
                keys[i] = e.getKey();
                values[i] = e.getValue();
                ++i;
            }
            this.applyToNative(StringConfigProviderOptions.getApiHandle(), this.nativeHandle, keys, values);
        }
    }

    protected abstract void applyToNative(long var1, long var3, String[] var5, String[] var6) throws OrtException;
}

