/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.common.configuration;

import io.higson.runtime.sql.dialect.DialectParser;
import java.sql.Connection;
import javax.sql.DataSource;
import liquibase.database.Database;
import liquibase.database.DatabaseConnection;
import liquibase.database.core.PostgresDatabase;
import liquibase.exception.DatabaseException;
import liquibase.integration.spring.SpringLiquibase;
import liquibase.resource.ResourceAccessor;
import org.apache.commons.lang3.StringUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.liquibase.LiquibaseProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(name={"spring.liquibase.url"})
@EnableConfigurationProperties(value={LiquibaseProperties.class})
public class LiquibaseConfiguration {
    private final LiquibaseProperties properties;

    @Bean
    public SpringLiquibase liquibase(DataSource dataSource) {
        System.setProperty("liquibase.allowDuplicatedChangesetIdentifiers", "true");
        HyperonSpringLiquibase liquibase = new HyperonSpringLiquibase();
        liquibase.setDataSource(dataSource);
        String databaseDialect = DialectParser.getDatabaseDialect((String)this.properties.getUrl());
        liquibase.setChangeLog("classpath:liquibase/changelog/" + databaseDialect + "/changelog.xml");
        liquibase.setClearCheckSums(this.properties.isClearChecksums());
        liquibase.setContexts(StringUtils.join((Object[])new Object[]{",", this.properties.getContexts()}));
        liquibase.setDefaultSchema(this.properties.getDefaultSchema());
        liquibase.setLiquibaseSchema(this.properties.getLiquibaseSchema());
        liquibase.setLiquibaseTablespace(this.properties.getLiquibaseTablespace());
        liquibase.setDatabaseChangeLogTable(this.properties.getDatabaseChangeLogTable());
        liquibase.setDatabaseChangeLogLockTable(this.properties.getDatabaseChangeLogLockTable());
        liquibase.setDropFirst(this.properties.isDropFirst());
        liquibase.setShouldRun(this.properties.isEnabled());
        liquibase.setChangeLogParameters(this.properties.getParameters());
        liquibase.setRollbackFile(this.properties.getRollbackFile());
        liquibase.setTestRollbackOnUpdate(this.properties.isTestRollbackOnUpdate());
        liquibase.setTag(this.properties.getTag());
        return liquibase;
    }

    public LiquibaseConfiguration(LiquibaseProperties properties) {
        this.properties = properties;
    }

    static class HyperonSpringLiquibase
    extends SpringLiquibase {
        HyperonSpringLiquibase() {
        }

        protected Database createDatabase(Connection c, ResourceAccessor resourceAccessor) throws DatabaseException {
            Database database = super.createDatabase(c, resourceAccessor);
            if (database instanceof PostgresDatabase) {
                return new HyperonPostgresDatabase(database.getConnection());
            }
            return database;
        }
    }

    static class HyperonPostgresDatabase
    extends PostgresDatabase {
        public HyperonPostgresDatabase(DatabaseConnection databaseConnection) {
            this.setConnection(databaseConnection);
        }

        protected boolean hasMixedCase(String tableName) {
            return false;
        }
    }
}

