/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.common.profiler;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import pl.decerto.hyperon.common.profiler.Profiler;

public abstract class ProfilerManager {
    public static final String GLOBAL_PROFILER_NAME = "GLOBAL_PROFILER";
    private static final Map<String, Profiler> PROFILERS = new HashMap<String, Profiler>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Profiler getProfiler(String name) {
        Profiler profiler = PROFILERS.get(name);
        if (profiler == null) {
            Map<String, Profiler> map = PROFILERS;
            synchronized (map) {
                profiler = PROFILERS.get(name);
                if (profiler == null) {
                    profiler = new Profiler(name);
                    PROFILERS.put(name, profiler);
                }
            }
        }
        return profiler;
    }

    public static Profiler.Monitor startProfile(String profilerName, String key) {
        return ProfilerManager.getProfiler(profilerName).startProfile(key);
    }

    public static <T> T doProfile(String profilerName, String key, Supplier<T> supplier) {
        try (Profiler.Monitor ignored = ProfilerManager.startProfile(profilerName, key);){
            T t = supplier.get();
            return t;
        }
    }

    public static int count(String profilerName, String key) {
        return Optional.ofNullable(PROFILERS.get(profilerName)).map(p -> p.getEntry(key)).map(Profiler.Entry::getCount).orElse(0);
    }

    public static void clear() {
        PROFILERS.clear();
    }

    public static void clear(String profilerName) {
        PROFILERS.remove(profilerName);
    }

    public static void clear(String profilerName, String key) {
        Profiler profiler = PROFILERS.get(profilerName);
        if (profiler != null) {
            profiler.clear(key);
        }
    }

    public static String print() {
        StringBuilder sb = new StringBuilder();
        sb.append("ProfilerManager").append("{GLOBAL_PROFILER_NAME=").append(GLOBAL_PROFILER_NAME).append('}');
        for (Map.Entry<String, Profiler> entry : PROFILERS.entrySet()) {
            sb.append("\n\n").append(entry.getKey());
        }
        return sb.toString();
    }

    public static String print(String profilerName) {
        Profiler profiler = PROFILERS.get(profilerName);
        if (profiler == null) {
            return profilerName + "=null";
        }
        return profiler.toString();
    }

    public static String print(String profilerName, String key) {
        Profiler profiler = PROFILERS.get(profilerName);
        if (profiler == null) {
            return profilerName + "=null";
        }
        Profiler.Entry entry = profiler.getEntry(key);
        if (entry == null) {
            return profilerName + "{" + key + "}=null";
        }
        return entry.toString();
    }
}

