/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.common.security;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import pl.decerto.hyperon.common.security.domain.SystemRights;

final class AuthoritiesCache {
    private static final Map<String, GrantedAuthority> authoritiesByCode = new ConcurrentHashMap<String, GrantedAuthority>();

    private static boolean isNotAccessControlTagRight(SystemRights value) {
        return SystemRights.PAR_W_CAT_ != value && SystemRights.PAR_R_CAT_ != value;
    }

    private AuthoritiesCache() {
        throw new UnsupportedOperationException();
    }

    static GrantedAuthority getAuthority(String rightsCode) {
        return authoritiesByCode.computeIfAbsent(rightsCode, SimpleGrantedAuthority::new);
    }

    static {
        for (SystemRights value : SystemRights.values()) {
            if (!AuthoritiesCache.isNotAccessControlTagRight(value)) continue;
            authoritiesByCode.put(value.name(), (GrantedAuthority)new SimpleGrantedAuthority(value.name()));
        }
    }
}

