/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.common.security;

import io.higson.runtime.exception.ImportException;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import pl.decerto.hyperon.common.security.SystemRoleManagementService;
import pl.decerto.hyperon.common.security.dao.SystemRightJPADao;
import pl.decerto.hyperon.common.security.dao.SystemRoleManagementDao;
import pl.decerto.hyperon.common.security.dao.UserManagementDao;
import pl.decerto.hyperon.common.security.domain.SystemRightJPA;
import pl.decerto.hyperon.common.security.domain.SystemRoleJPA;
import pl.decerto.hyperon.common.security.dto.SystemRightDto;
import pl.decerto.hyperon.common.security.dto.SystemRole;
import pl.decerto.hyperon.common.security.mapper.SystemRoleFullMapper;
import pl.decerto.hyperon.common.security.mapper.SystemRoleMapper;
import pl.decerto.hyperon.common.utils.Messages;

@Service
public class SystemRoleManagementServiceImpl
implements SystemRoleManagementService {
    private static final Logger log = LoggerFactory.getLogger(SystemRoleManagementServiceImpl.class);
    private final SystemRoleManagementDao dao;
    private final SystemRightJPADao rightDao;
    private final UserManagementDao userDao;
    private final SystemRoleMapper systemRoleMapper;
    private final SystemRoleFullMapper systemRoleFullMapper;

    @Autowired
    public SystemRoleManagementServiceImpl(SystemRoleManagementDao dao, SystemRightJPADao rightDao, UserManagementDao userDao, SystemRoleMapper systemRoleMapper, SystemRoleFullMapper systemRoleFullMapper) {
        this.dao = dao;
        this.rightDao = rightDao;
        this.userDao = userDao;
        this.systemRoleMapper = systemRoleMapper;
        this.systemRoleFullMapper = systemRoleFullMapper;
    }

    @Override
    @Transactional(readOnly=true)
    public List<SystemRole> getRoles() {
        log.trace("fetching all roles");
        Iterable allUsers = this.dao.findAll();
        log.trace("fetched {} roles", (Object)allUsers.size());
        return allUsers.stream().map(this.systemRoleFullMapper::toDto).collect(Collectors.toList());
    }

    @Override
    @Transactional(readOnly=true)
    public SystemRole getRoleByCode(String code) {
        return this.systemRoleFullMapper.toDto(this.dao.findByCode(code));
    }

    @Override
    @Transactional
    public void add(SystemRole dto) {
        log.info("creating role: {}", (Object)dto.getCode());
        SystemRoleJPA newRole = this.systemRoleMapper.toModel(dto);
        newRole.setCreateDate(new Date());
        this.throwIfRoleExists(newRole.getCode(), newRole.getId());
        this.setRights(dto, newRole);
        this.dao.save(newRole);
        this.userDao.updateLastUpdateViaRoles(Collections.singletonList(newRole.getId()));
        dto.setId(newRole.getId());
        dto.setCreateDate(newRole.getCreateDate());
        log.debug("role {} created", (Object)dto.getCode());
    }

    @Override
    @Transactional
    public void modify(SystemRole dto) {
        log.info("modifying role: {}", (Object)dto.getCode());
        SystemRoleJPA role = this.systemRoleMapper.toModel(dto);
        this.throwIfRoleExists(role.getCode(), role.getId());
        this.setRights(dto, role);
        this.dao.save(role);
        this.userDao.updateLastUpdateViaRoles(Collections.singletonList(role.getId()));
        log.debug("role {} modified", (Object)dto.getCode());
    }

    private void setRights(SystemRole dto, SystemRoleJPA role) {
        if (!dto.getRights().isEmpty()) {
            List<Integer> rightsIds = this.findRightsIds(dto);
            Iterable rightsJPA = this.rightDao.findAllById(rightsIds);
            for (SystemRightJPA systemRightJPA : rightsJPA) {
                role.addRight(systemRightJPA);
            }
        }
    }

    private void throwIfRoleExists(String code, int newRoleId) {
        SystemRoleJPA roleFromBase = this.dao.findByCode(code);
        if (roleFromBase != null && roleFromBase.getId() != newRoleId) {
            log.info("role {} exists. Aborting", (Object)code);
            throw new SystemRoleManagementService.SystemRoleExistsException();
        }
    }

    @Override
    @Transactional
    public void remove(int id) {
        log.info("deleting role with id: {}", (Object)id);
        this.throwIfRoleIsUsed(id);
        this.dao.deleteById(id);
        log.debug("role with id {} deleted", (Object)id);
    }

    private void throwIfRoleIsUsed(int id) {
        SystemRoleJPA role;
        Optional roleOpt = this.dao.findById(id);
        if (roleOpt.isPresent() && !(role = (SystemRoleJPA)roleOpt.get()).getUsers().isEmpty()) {
            log.info("role {} is being used. Aborting", (Object)role.getCode());
            throw new SystemRoleManagementService.SystemRoleIsUsedException();
        }
    }

    @Override
    public void importRole(SystemRole role) {
        SystemRoleJPA roleJpa = this.dao.findByCode(role.getCode());
        if (roleJpa != null && StringUtils.equals((CharSequence)role.getDescription(), (CharSequence)roleJpa.getDescription())) {
            return;
        }
        if (roleJpa == null) {
            roleJpa = new SystemRoleJPA();
            roleJpa.setCode(role.getCode());
        }
        roleJpa.setDescription(role.getDescription());
        this.dao.save(roleJpa);
    }

    @Override
    @Transactional
    public void importRoleRight(String roleCode, String rightCode) {
        SystemRoleJPA roleJpa = this.dao.findByCode(roleCode);
        if (roleJpa == null) {
            throw new ImportException(Messages.message("roles.import.noRole", roleCode));
        }
        SystemRightJPA rightJpa = this.rightDao.getByCode(rightCode);
        if (rightJpa == null) {
            throw new ImportException(Messages.message("roles.import.noRight", roleCode));
        }
        if (roleJpa.getRights().contains(rightJpa)) {
            return;
        }
        roleJpa.addRight(rightJpa);
        this.dao.save(roleJpa);
    }

    private List<Integer> findRightsIds(SystemRole dto) {
        return dto.getRights().stream().map(SystemRightDto::getId).collect(Collectors.toList());
    }
}

